/*
 * Decompiled with CFR 0.152.
 */
package ilog.concert.model;

import ilog.concert.IloException;
import ilog.solver.IlcDec;
import java.util.Arrays;

public class IlcIntervalUnion {
    private double by = Double.NEGATIVE_INFINITY;
    private double cy = Double.POSITIVE_INFINITY;
    private double[] dy;
    private double[] ey;

    public double getDiameter() {
        return this.cy - this.by;
    }

    public int getNumber() {
        return this.dy.length;
    }

    public double getLB() {
        return this.by;
    }

    public double getUB() {
        return this.cy;
    }

    public double[] getLBs() {
        return this.dy;
    }

    public double[] getUBs() {
        return this.ey;
    }

    public double getLBs(int n2) {
        return this.dy[n2];
    }

    public double getUBs(int n2) {
        return this.ey[n2];
    }

    public int getIndex(double d2) {
        int n2 = 0;
        int n3 = this.dy.length - 1;
        while (n2 <= n3) {
            int n4 = (n3 + n2) / 2;
            if (this.dy[n4] > d2) {
                n3 = n4 - 1;
                continue;
            }
            if (this.ey[n4] < d2) {
                n2 = n4 + 1;
                continue;
            }
            return n4;
        }
        return -1;
    }

    public double getIntersectedLB(double d2) {
        int n2 = this.ey.length;
        int n3 = 0;
        while (n3 < n2) {
            if (this.ey[n3] >= d2) {
                if (this.dy[n3] <= d2) {
                    return d2;
                }
                return this.dy[n3];
            }
            ++n3;
        }
        return Double.POSITIVE_INFINITY;
    }

    public double getIntersectedUB(double d2) {
        int n2 = this.dy.length;
        int n3 = n2 - 1;
        while (n3 >= 0) {
            if (this.dy[n3] <= d2) {
                if (this.ey[n3] >= d2) {
                    return d2;
                }
                return this.ey[n3];
            }
            --n3;
        }
        return Double.NEGATIVE_INFINITY;
    }

    public boolean includes(IlcIntervalUnion ilcIntervalUnion) throws IloException {
        if (this.by > ilcIntervalUnion.getLB() || ilcIntervalUnion.getUB() > this.cy) {
            return false;
        }
        int n2 = 0;
        while (n2 < ilcIntervalUnion.getNumber()) {
            if (!this.includes(ilcIntervalUnion.getLBs(n2), ilcIntervalUnion.getUBs(n2))) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public boolean includes(double d2, double d3) throws IloException {
        int n2 = 0;
        while (n2 < this.getNumber()) {
            if (!(this.ey[n2] < d2)) {
                if (this.dy[n2] > d3) {
                    return false;
                }
                if (this.ey[n2] >= d3 && this.dy[n2] <= d2) {
                    return true;
                }
            }
            ++n2;
        }
        return false;
    }

    public long[] getLongValues(int n2) {
        int n3 = this.dy.length;
        long[] lArray = new long[n3];
        int n4 = 0;
        while (n4 < n3) {
            lArray[n4] = IlcDec.round(this.dy[n4], n2);
            ++n4;
        }
        return lArray;
    }

    public IlcIntervalUnion(long[] lArray, int n2) throws IloException {
        int n3 = lArray.length;
        this.dy = new double[n3];
        this.ey = new double[n3];
        int n4 = 0;
        while (n4 < n3) {
            this.dy[n4] = IlcDec.getValueLB(lArray[n4], n2);
            this.ey[n4] = IlcDec.getValueUB(lArray[n4], n2);
            ++n4;
        }
        Arrays.sort(this.dy);
        Arrays.sort(this.ey);
        this.by = this.dy[0];
        this.cy = this.ey[n3 - 1];
    }

    public IlcIntervalUnion(String[] stringArray, int n2) throws IloException {
        int n3 = stringArray.length;
        this.dy = new double[n3];
        this.ey = new double[n3];
        int n4 = 0;
        while (n4 < n3) {
            this.dy[n4] = IlcDec.getValueLB(stringArray[n4], n2);
            this.ey[n4] = IlcDec.getValueUB(stringArray[n4], n2);
            ++n4;
        }
        Arrays.sort(this.dy);
        Arrays.sort(this.ey);
        this.by = this.dy[0];
        this.cy = this.ey[n3 - 1];
    }

    public IlcIntervalUnion(String[] stringArray) throws IloException {
        int n2 = stringArray.length;
        this.dy = new double[n2];
        this.ey = new double[n2];
        int n3 = 0;
        while (n3 < n2) {
            this.dy[n3] = IlcDec.getValueLB(stringArray[n3]);
            this.ey[n3] = IlcDec.getValueUB(stringArray[n3]);
            ++n3;
        }
        Arrays.sort(this.dy);
        Arrays.sort(this.ey);
        this.by = this.dy[0];
        this.cy = this.ey[n2 - 1];
    }

    public IlcIntervalUnion(IlcIntervalUnion ilcIntervalUnion) throws IloException {
        double[] dArray = ilcIntervalUnion.getLBs();
        double[] dArray2 = ilcIntervalUnion.getUBs();
        int n2 = dArray.length;
        this.dy = new double[n2];
        this.ey = new double[n2];
        int n3 = 0;
        while (n3 < n2) {
            this.dy[n3] = dArray[n3];
            this.ey[n3] = dArray2[n3];
            ++n3;
        }
        this.by = ilcIntervalUnion.getLB();
        this.cy = ilcIntervalUnion.getUB();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{");
        int n2 = this.dy.length;
        int n3 = 0;
        while (n3 < n2) {
            if (n3 != 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append("[");
            stringBuffer.append(this.dy[n3]);
            stringBuffer.append(",");
            stringBuffer.append(this.ey[n3]);
            stringBuffer.append("]");
            ++n3;
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public String toString(int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        int n3 = this.dy.length;
        int n4 = 0;
        while (n4 < n3) {
            if (n4 != 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(IlcDec.toStringDown(this.ey[n4], n2));
            ++n4;
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public IlcIntervalUnion makeCopy() throws IloException {
        return new IlcIntervalUnion(this);
    }
}

