/*
 * Decompiled with CFR 0.152.
 */
package ilog.concert.model;

import ilog.concert.IloCPModeler;
import ilog.concert.IloCopyManager;
import ilog.concert.IloCopyable;
import ilog.concert.IloDecDomain;
import ilog.concert.IloDomain;
import ilog.concert.IloException;
import ilog.concert.model.IlcDomain;
import ilog.concert.model.IlcIntervalUnion;
import ilog.solver.IlcDec;

public class IlcDecDomain
extends IlcDomain
implements IloDecDomain {
    private double ri = Double.NEGATIVE_INFINITY;
    private double si = Double.POSITIVE_INFINITY;
    private int ti;
    private IlcIntervalUnion ui = null;

    public double getDiameter() {
        return this.si - this.ri;
    }

    public int getScale() {
        return this.ti;
    }

    public double getLB() {
        return this.ri;
    }

    public void setLB(double d2) {
        this.ri = d2;
    }

    public double getUB() {
        return this.si;
    }

    public void setUB(double d2) {
        this.si = d2;
    }

    public boolean includes(IloDomain iloDomain) throws IloException {
        IloDecDomain iloDecDomain = (IloDecDomain)iloDomain;
        if (this.getScale() != iloDecDomain.getScale()) {
            throw new IloException("Decimal domains " + this + " and " + iloDecDomain + " should have the same scale.");
        }
        if (this.ri > iloDecDomain.getLB() || iloDecDomain.getUB() > this.si) {
            return false;
        }
        if (this.ui != null) {
            if (iloDecDomain.isEnumerated()) {
                int n2 = 0;
                while (n2 < iloDecDomain.getSize()) {
                    if (!this.ui.includes(iloDecDomain.getLB(n2), iloDecDomain.getUB(n2))) {
                        return false;
                    }
                    ++n2;
                }
                return true;
            }
            double d2 = iloDecDomain.getLB();
            while (d2 < iloDecDomain.getUB()) {
                if (!this.ui.includes(d2, d2)) {
                    return false;
                }
                d2 = IlcDec.nextUp(d2, this.ti);
            }
            return true;
        }
        return true;
    }

    public IlcIntervalUnion getIntervals() {
        return this.ui;
    }

    public boolean isEnumerated() {
        return this.ui != null;
    }

    public int getSize() {
        if (this.ui != null) {
            return this.ui.getNumber();
        }
        double d2 = IlcDec.unscaledCastUp(this.getLB(), this.getScale());
        double d3 = IlcDec.unscaledCastDown(this.getUB(), this.getScale());
        return (int)(d3 - d2 + 1.0);
    }

    public double getLB(int n2) throws IloException {
        if (this.ui != null) {
            return this.ui.getLBs(n2);
        }
        throw new IloException("function getLB(int) cannot be applied on non enumerated domains");
    }

    public double getUB(int n2) throws IloException {
        if (this.ui != null) {
            return this.ui.getUBs(n2);
        }
        throw new IloException("function getLB(int) cannot be applied on non enumerated domains");
    }

    public int getIndex(double d2) throws IloException {
        if (this.ui != null) {
            int n2 = this.ui.getIndex(d2);
            if (n2 < 0) {
                throw new IloException("The double is not in the initial domain");
            }
            return n2;
        }
        throw new IloException("getIndex(double d) not defined for non enumerateddecimal domain. Use getIndexOfUnscaled");
    }

    public int getIndexOfUnscaled(double d2) throws IloException {
        if (this.ui != null) {
            int n2 = this.ui.getIndex(IlcDec.getScaledUB(d2, this.ti));
            if (n2 < 0) {
                throw new IloException("The double is not in the initial domain");
            }
            return n2;
        }
        double d3 = IlcDec.unscaledCastUp(this.ri, this.ti);
        return (int)(d2 - d3);
    }

    public int getIndexOfScaled(double d2) throws IloException {
        return this.getIndexOfUnscaled(IlcDec.round(d2, this.ti));
    }

    public boolean isIndexable() {
        if (this.ui == null) {
            double d2 = IlcDec.unscaledCastUp(this.getLB(), this.getScale());
            double d3 = IlcDec.unscaledCastDown(this.getUB(), this.getScale());
            return !(d3 - d2 > 2.147483647E9);
        }
        return true;
    }

    public IlcDecDomain(double d2, double d3, int n2) throws IloException {
        this.ti = n2;
        this.ri = IlcDec.castUp(d2, n2);
        this.si = IlcDec.castDown(d3, n2);
        if (this.ri > this.si) {
            throw new IloException("Declaring invalid decimal domain.");
        }
    }

    public IlcDecDomain(long l2, long l3, int n2) throws IloException {
        if (l2 > l3) {
            throw new IloException("Declaring invalid decimal domain.");
        }
        this.ti = n2;
        this.ri = IlcDec.getValueLB(l2, n2);
        this.si = IlcDec.getValueUB(l3, n2);
    }

    public IlcDecDomain(long[] lArray, int n2) throws IloException {
        this.ti = n2;
        this.ui = new IlcIntervalUnion(lArray, n2);
        this.ri = this.ui.getLB();
        this.si = this.ui.getUB();
    }

    public IlcDecDomain(String string, String string2) throws IloException {
        int n2 = IlcDec.getValuePrecision(string);
        int n3 = IlcDec.getValuePrecision(string2);
        if (n2 != n3) {
            throw new IloException("Declaring decimal domain with different scales: " + n2 + " and " + n3);
        }
        this.ti = n2;
        this.ri = IlcDec.getValueLB(string);
        this.si = IlcDec.getValueUB(string2);
        if (this.ri > this.si) {
            throw new IloException("Declaring invalid decimal domain bounds: " + string + " and " + string2);
        }
    }

    public IlcDecDomain(String string, String string2, int n2) throws IloException {
        this.ti = n2;
        this.ri = IlcDec.getValueLB(string, n2);
        this.si = IlcDec.getValueUB(string2, n2);
        if (this.ri > this.si) {
            throw new IloException("Declaring invalid decimal domain bounds: " + string + " and " + string2);
        }
    }

    public IlcDecDomain(String[] stringArray, int n2) throws IloException {
        this.ti = n2;
        this.ui = new IlcIntervalUnion(stringArray);
        this.ri = this.ui.getLB();
        this.si = this.ui.getUB();
    }

    public IlcDecDomain(String[] stringArray) throws IloException {
        this.ti = IlcDec.getValuePrecision(stringArray[0]);
        this.ui = new IlcIntervalUnion(stringArray);
        this.ri = this.ui.getLB();
        this.si = this.ui.getUB();
    }

    public IlcDecDomain(IlcIntervalUnion ilcIntervalUnion, int n2) throws IloException {
        this.ti = n2;
        this.ui = new IlcIntervalUnion(ilcIntervalUnion);
        this.ri = this.ui.getLB();
        this.si = this.ui.getUB();
    }

    public String printType() {
        return "dec";
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.ui == null) {
            stringBuffer.append("[");
            String string = IlcDec.toStringUp(this.ri, this.ti);
            String string2 = IlcDec.toStringDown(this.si, this.ti);
            stringBuffer.append(string);
            if (!string.equals(string2)) {
                stringBuffer.append("..");
                stringBuffer.append(string2);
            }
            stringBuffer.append("]");
        } else {
            stringBuffer.append(this.ui.toString(this.ti));
        }
        return stringBuffer.toString();
    }

    public IloCopyable makeCopy(IloCopyManager iloCopyManager) throws IloException {
        IloCPModeler iloCPModeler = (IloCPModeler)iloCopyManager.getModeler();
        if (this.ui == null) {
            return iloCPModeler.decDomain(IlcDec.toStringUp(this.ri, this.ti), IlcDec.toStringDown(this.si, this.ti), this.ti);
        }
        return iloCPModeler.decDomain(this.ui.getLongValues(this.ti), this.ti);
    }
}

