/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.stat.descriptive.summary;

import java.io.Serializable;
import org.apache.commons.math.stat.descriptive.AbstractStorelessUnivariateStatistic;

public class SumOfSquares
extends AbstractStorelessUnivariateStatistic
implements Serializable {
    private static final long serialVersionUID = 1460986908574398008L;
    private long n = 0L;
    private double value = Double.NaN;

    public void increment(double d) {
        this.value = this.n == 0L ? d * d : (this.value += d * d);
        ++this.n;
    }

    public double getResult() {
        return this.value;
    }

    public long getN() {
        return this.n;
    }

    public void clear() {
        this.value = Double.NaN;
        this.n = 0L;
    }

    public double evaluate(double[] values, int begin, int length) {
        double sumSq = Double.NaN;
        if (this.test(values, begin, length)) {
            sumSq = 0.0;
            int i = begin;
            while (i < begin + length) {
                sumSq += values[i] * values[i];
                ++i;
            }
        }
        return sumSq;
    }
}

