/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.space;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import uchicago.src.sim.space.AbstractNeighborhooder;
import uchicago.src.sim.space.IMulti2DGrid;
import uchicago.src.sim.space.ObjectLocation;
import uchicago.src.sim.space.Torus;

public class MooreMultiNeighborhooder
extends AbstractNeighborhooder {
    private NeighMaker maker;

    public MooreMultiNeighborhooder(IMulti2DGrid iMulti2DGrid) {
        super(iMulti2DGrid);
        this.maker = iMulti2DGrid instanceof Torus ? new NeighMakerTorus(iMulti2DGrid) : new NeighMakerGrid(iMulti2DGrid);
    }

    public Vector getNeighbors(int n, int n2, int[] nArray, boolean bl) {
        return new Vector(this.getNeighborsList(n, n2, nArray, bl));
    }

    public ArrayList getNeighborsList(int n, int n2, int[] nArray, boolean bl) {
        return this.maker.getNeighbors(n, n2, nArray[0], nArray[1], bl);
    }

    public ArrayList getNeighborsLoc(int n, int n2, int[] nArray, boolean bl) {
        return this.maker.getNeighborsLoc(n, n2, nArray[0], nArray[1], bl);
    }

    class NeighMakerGrid
    extends NeighMaker {
        public NeighMakerGrid(IMulti2DGrid iMulti2DGrid) {
            super(iMulti2DGrid);
        }

        public ArrayList getNeighbors(int n, int n2, int n3, int n4, boolean bl) {
            ArrayList arrayList = new ArrayList(n3 * n4 * 4 + n3 * 2 + n4 * 2);
            int n5 = n3;
            int n6 = n3;
            if (n - n5 < 0) {
                n5 = n;
            }
            if (n6 + n > this.xSize - 1) {
                n6 = this.xSize - 1 - n;
            }
            int n7 = n4;
            int n8 = n4;
            if (n2 + n8 > this.ySize - 1) {
                n8 = this.ySize - 1 - n2;
            }
            if (n2 - n7 < 0) {
                n7 = n2;
            }
            for (int i = n2 - n7; i <= n2 + n8; ++i) {
                for (int j = n - n5; j <= n + n6; ++j) {
                    if (i == n2 && j == n) continue;
                    List list = this.grid.getObjectsAt(j, i);
                    int n9 = list.size();
                    if (n9 == 0 && bl) {
                        arrayList.add(null);
                        continue;
                    }
                    if (n9 <= 0) continue;
                    arrayList.addAll(list);
                }
            }
            return arrayList;
        }

        public ArrayList getNeighborsLoc(int n, int n2, int n3, int n4, boolean bl) {
            ArrayList<ObjectLocation> arrayList = new ArrayList<ObjectLocation>(n3 * n4 * 4 + n3 * 2 + n4 * 2);
            int n5 = n3;
            int n6 = n3;
            if (n - n5 < 0) {
                n5 = n;
            }
            if (n6 + n > this.xSize - 1) {
                n6 = this.xSize - 1 - n;
            }
            int n7 = n4;
            int n8 = n4;
            if (n2 + n8 > this.ySize - 1) {
                n8 = this.ySize - 1 - n2;
            }
            if (n2 - n7 < 0) {
                n7 = n2;
            }
            for (int i = n2 - n7; i <= n2 + n8; ++i) {
                for (int j = n - n5; j <= n + n6; ++j) {
                    if (i == n2 && j == n) continue;
                    List list = this.grid.getObjectsAt(j, i);
                    int n9 = list.size();
                    if (n9 == 0 && bl) {
                        arrayList.add(new ObjectLocation(null, j, i));
                        continue;
                    }
                    if (n9 <= 0) continue;
                    arrayList.addAll(ObjectLocation.makeObjectLocations(list, j, i));
                }
            }
            return arrayList;
        }
    }

    class NeighMakerTorus
    extends NeighMaker {
        public NeighMakerTorus(IMulti2DGrid iMulti2DGrid) {
            super(iMulti2DGrid);
        }

        public ArrayList getNeighbors(int n, int n2, int n3, int n4, boolean bl) {
            ArrayList arrayList = new ArrayList(n3 * n4 * 4 + n3 * 2 + n4 * 2);
            for (int i = n2 - n4; i <= n2 + n4; ++i) {
                for (int j = n - n3; j <= n + n3; ++j) {
                    if (i == n2 && j == n) continue;
                    List list = this.grid.getObjectsAt(j, i);
                    int n5 = list.size();
                    if (n5 == 0 && bl) {
                        arrayList.add(null);
                        continue;
                    }
                    if (n5 <= 0) continue;
                    arrayList.addAll(list);
                }
            }
            return arrayList;
        }

        public ArrayList getNeighborsLoc(int n, int n2, int n3, int n4, boolean bl) {
            ArrayList<ObjectLocation> arrayList = new ArrayList<ObjectLocation>(n3 * n4 * 4 + n3 * 2 + n4 * 2);
            for (int i = n2 - n4; i <= n2 + n4; ++i) {
                for (int j = n - n3; j <= n + n3; ++j) {
                    if (i == n2 && j == n) continue;
                    List list = this.grid.getObjectsAt(j, i);
                    int n5 = list.size();
                    if (n5 == 0 && bl) {
                        arrayList.add(new ObjectLocation(null, this.xnorm(j), this.ynorm(i)));
                        continue;
                    }
                    if (n5 <= 0) continue;
                    arrayList.addAll(ObjectLocation.makeObjectLocations(list, this.xnorm(j), this.ynorm(i)));
                }
            }
            return arrayList;
        }
    }

    abstract class NeighMaker {
        protected IMulti2DGrid grid;
        protected int xSize;
        protected int ySize;

        public NeighMaker(IMulti2DGrid iMulti2DGrid) {
            this.grid = iMulti2DGrid;
            this.xSize = iMulti2DGrid.getSizeX();
            this.ySize = iMulti2DGrid.getSizeY();
        }

        public abstract ArrayList getNeighbors(int var1, int var2, int var3, int var4, boolean var5);

        public abstract ArrayList getNeighborsLoc(int var1, int var2, int var3, int var4, boolean var5);

        public int xnorm(int n) {
            if (n > this.xSize - 1 || n < 0) {
                while (n < 0) {
                    n += this.xSize;
                }
                return n % this.xSize;
            }
            return n;
        }

        public int ynorm(int n) {
            if (n > this.ySize - 1 || n < 0) {
                while (n < 0) {
                    n += this.ySize;
                }
                return n % this.ySize;
            }
            return n;
        }
    }
}

