/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.gui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import uchicago.src.collection.BaseMatrix;
import uchicago.src.sim.gui.Display2D;
import uchicago.src.sim.gui.DisplayInfo;
import uchicago.src.sim.gui.Drawable;
import uchicago.src.sim.gui.Moveable;
import uchicago.src.sim.gui.Probeable;
import uchicago.src.sim.gui.SimGraphics;
import uchicago.src.sim.gui.ViewEvent;
import uchicago.src.sim.space.Discrete2DSpace;

public class Object2DDisplay
extends Display2D
implements Probeable {
    protected Collection objsToDraw = null;
    protected boolean view = true;

    public Object2DDisplay(Discrete2DSpace discrete2DSpace) {
        super(discrete2DSpace);
    }

    public void setObjectList(Collection collection) {
        this.objsToDraw = collection;
    }

    public ArrayList getObjectsAt(int n, int n2) {
        if (n2 != 0) {
            n2 /= SimGraphics.getInstance().getCellHeightScale();
        }
        if (n != 0) {
            n /= SimGraphics.getInstance().getCellWidthScale();
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (n > this.grid.getSizeX() || n < 0 || n2 > this.grid.getSizeY() || n2 < 0) {
            return arrayList;
        }
        arrayList.add(this.grid.getObjectAt(n, n2));
        return arrayList;
    }

    public void setMoveableXY(Moveable moveable, int n, int n2) {
        moveable.setX(n / SimGraphics.getInstance().getCellWidthScale());
        moveable.setY(n2 / SimGraphics.getInstance().getCellHeightScale());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawDisplay(SimGraphics simGraphics) {
        if (!this.view) {
            return;
        }
        int n = simGraphics.getCellWidthScale();
        int n2 = simGraphics.getCellHeightScale();
        Drawable drawable = null;
        if (this.objsToDraw == null) {
            BaseMatrix baseMatrix;
            BaseMatrix baseMatrix2 = baseMatrix = this.grid.getMatrix();
            synchronized (baseMatrix2) {
                int n3 = this.grid.getSizeX();
                for (int i = 0; i < n3; ++i) {
                    int n4 = this.grid.getSizeY();
                    for (int j = 0; j < n4; ++j) {
                        drawable = (Drawable)baseMatrix.get(i, j);
                        if (drawable == null) continue;
                        simGraphics.setDrawingCoordinates(i * n, j * n2, 0.0f);
                        drawable.draw(simGraphics);
                    }
                }
            }
        } else {
            Iterator iterator = this.objsToDraw.iterator();
            while (iterator.hasNext()) {
                drawable = (Drawable)iterator.next();
                simGraphics.setDrawingCoordinates(drawable.getX() * n, drawable.getY() * n2, 0.0f);
                drawable.draw(simGraphics);
            }
        }
    }

    public ArrayList getDisplayableInfo() {
        ArrayList<DisplayInfo> arrayList = new ArrayList<DisplayInfo>();
        arrayList.add(new DisplayInfo("", -1, this));
        return arrayList;
    }

    public void viewEventPerformed(ViewEvent viewEvent) {
        this.view = viewEvent.showView();
    }
}

