/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.analysis;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Date;
import java.util.Iterator;
import uchicago.src.sim.analysis.SimDataNew;
import uchicago.src.sim.util.SimUtilities;

public class DataWriter {
    String fileName;
    private boolean fileSet = false;

    public DataWriter() {
        this.fileName = null;
    }

    public DataWriter(String string) {
        this.fileName = string;
    }

    public void setFile(String string) {
        this.fileName = string;
        this.fileSet = true;
    }

    public boolean isFileSet() {
        return this.fileSet;
    }

    public synchronized void write(SimDataNew simDataNew, boolean bl) {
        BufferedWriter bufferedWriter = null;
        try {
            if (bl) {
                this.renameFile();
                bufferedWriter = new BufferedWriter(new FileWriter(this.fileName, true));
                bufferedWriter.write(simDataNew.getModelHeader());
                bufferedWriter.newLine();
                bufferedWriter.newLine();
                bufferedWriter.write(simDataNew.getHeader());
                bufferedWriter.newLine();
                bl = false;
            }
            if (bufferedWriter == null) {
                bufferedWriter = new BufferedWriter(new FileWriter(this.fileName, true));
            }
            Iterator iterator = simDataNew.iterator();
            while (iterator.hasNext()) {
                bufferedWriter.write((String)iterator.next());
            }
            bufferedWriter.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            try {
                bufferedWriter.flush();
                bufferedWriter.close();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            System.exit(0);
        }
    }

    public synchronized void writeEnd() {
        BufferedWriter bufferedWriter = null;
        try {
            bufferedWriter = new BufferedWriter(new FileWriter(this.fileName, true));
            Date date = new Date();
            String string = DateFormat.getDateTimeInstance().format(date);
            bufferedWriter.newLine();
            bufferedWriter.write("End Time: " + string);
            bufferedWriter.flush();
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            SimUtilities.showError("Unable to write footer to file", iOException);
            iOException.printStackTrace();
            try {
                bufferedWriter.flush();
                bufferedWriter.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            System.exit(0);
        }
    }

    private void renameFile() throws IOException {
        File file = new File(this.fileName);
        this.fileName = file.getCanonicalPath();
        if (file.exists()) {
            File file2;
            int n = 1;
            String string = this.fileName;
            String string2 = "";
            if (this.fileName.indexOf(".") != -1) {
                int n2 = this.fileName.lastIndexOf(".");
                string = this.fileName.substring(0, n2);
                string2 = this.fileName.substring(n2, this.fileName.length());
            }
            string = string + ".bak";
            do {
                file2 = new File(string + n + string2);
                ++n;
            } while (file2.exists());
            file.renameTo(file2);
            file.delete();
        }
    }
}

