/*
 * Decompiled with CFR 0.152.
 */
package anl.repast.gis.data;

import anl.repast.gis.GisAgent;
import anl.repast.gis.OpenMapAgent;
import anl.repast.gis.data.FeatureArrayList;
import anl.repast.gis.data.FieldNameAndType;
import anl.repast.gis.data.dbf.DBFReader;
import anl.repast.gis.data.dbf.DBFWriter;
import anl.repast.gis.data.dbf.JDBFException;
import anl.repast.gis.data.dbf.JDBField;
import com.bbn.openmap.LatLonPoint;
import com.bbn.openmap.MapBean;
import com.bbn.openmap.MapHandler;
import com.bbn.openmap.dataAccess.shape.DbfTableModel;
import com.bbn.openmap.dataAccess.shape.EsriGraphic;
import com.bbn.openmap.dataAccess.shape.EsriGraphicList;
import com.bbn.openmap.dataAccess.shape.EsriPoint;
import com.bbn.openmap.dataAccess.shape.EsriPointList;
import com.bbn.openmap.dataAccess.shape.EsriPolygon;
import com.bbn.openmap.dataAccess.shape.EsriPolygonList;
import com.bbn.openmap.dataAccess.shape.EsriPolyline;
import com.bbn.openmap.dataAccess.shape.EsriPolylineList;
import com.bbn.openmap.dataAccess.shape.EsriShapeExport;
import com.bbn.openmap.dataAccess.shape.input.ShpInputStream;
import com.bbn.openmap.dataAccess.shape.input.ShxInputStream;
import com.bbn.openmap.geo.Geo;
import com.bbn.openmap.gui.BasicMapPanel;
import com.bbn.openmap.gui.OpenMapFrame;
import com.bbn.openmap.layer.shape.ShapeFile;
import com.bbn.openmap.layer.shape.ShapeLayer;
import com.bbn.openmap.omGraphics.DrawingAttributes;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.omGraphics.OMPoint;
import com.bbn.openmap.omGraphics.OMPoly;
import com.bbn.openmap.plugin.esri.EsriLayer;
import com.bbn.openmap.proj.Projection;
import com.vividsolutions.jts.geom.Geometry;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.regex.Pattern;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureResults;
import org.geotools.data.FeatureSource;
import org.geotools.data.FeatureStore;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.shapefile.dbf.DbaseFileHeader;
import org.geotools.data.shapefile.dbf.DbaseFileReader;
import org.geotools.feature.AttributeType;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureType;
import org.geotools.feature.IllegalAttributeException;

public class OpenMapData {
    OpenMapFrame frame;
    BasicMapPanel mapPanel;
    MapBean mapBean;
    MapHandler mapHandler;
    ShapeLayer shapeLayer;
    public static final int SHP_POINT = 0;
    public static final int SHP_POLYLINE = 3;
    public static final int SHP_POLYGON = 5;
    private static OpenMapData instance = new OpenMapData();
    static /* synthetic */ Class class$org$geotools$geometry$Geometry;

    public static OpenMapData getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readNeighborhoodInfo(String string, ArrayList arrayList) {
        BufferedReader bufferedReader = null;
        try {
            Pattern pattern = Pattern.compile(" ");
            String string2 = new String();
            bufferedReader = new BufferedReader(new FileReader(string));
            int n = 0;
            bufferedReader.readLine();
            while ((string2 = bufferedReader.readLine()) != null) {
                int[] nArray;
                String[] stringArray = pattern.split(string2);
                n = Integer.parseInt(stringArray[0]) - 1;
                if (Integer.parseInt(stringArray[1]) > 0) {
                    string2 = bufferedReader.readLine();
                    stringArray = pattern.split(string2);
                    nArray = new int[stringArray.length];
                    for (int i = 0; i < stringArray.length; ++i) {
                        nArray[i] = Integer.parseInt(stringArray[i]) - 1;
                    }
                    ((GisAgent)arrayList.get(n)).setNeighbors(nArray);
                    continue;
                }
                string2 = bufferedReader.readLine();
                nArray = new int[]{};
                ((GisAgent)arrayList.get(n)).setNeighbors(nArray);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList createAgents(Class clazz, String string) {
        ArrayList arrayList = new ArrayList();
        AbstractInterruptibleChannel abstractInterruptibleChannel = null;
        DbaseFileReader dbaseFileReader = null;
        try {
            String string2 = string.substring(0, string.length() - 3);
            String string3 = string2 + "dbf";
            abstractInterruptibleChannel = new FileInputStream(string3).getChannel();
            dbaseFileReader = new DbaseFileReader((ReadableByteChannel)((Object)abstractInterruptibleChannel));
            DbaseFileHeader dbaseFileHeader = dbaseFileReader.getHeader();
            int n = dbaseFileHeader.getNumRecords();
            for (int i = 0; i < n; ++i) {
                Object t = clazz.newInstance();
                ((GisAgent)t).setGisAgentIndex(i);
                arrayList.add(t);
            }
            ArrayList arrayList2 = this.updateAgentsFromShapefile(clazz, arrayList, string);
            return arrayList2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (abstractInterruptibleChannel != null) {
                try {
                    abstractInterruptibleChannel.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            if (dbaseFileReader != null) {
                try {
                    dbaseFileReader.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList updateAgentsFromShapefile(Class clazz, ArrayList arrayList, String string) {
        FeatureReader featureReader = null;
        try {
            Method method;
            Object object;
            OMGraphic oMGraphic;
            Object[] objectArray;
            String string2 = string.substring(0, string.length() - 3);
            String string3 = string2 + "shx";
            FileInputStream fileInputStream = new FileInputStream(string3);
            FileInputStream fileInputStream2 = new FileInputStream(string);
            ShxInputStream shxInputStream = new ShxInputStream((InputStream)fileInputStream);
            int[][] nArray = shxInputStream.getIndex();
            ShpInputStream shpInputStream = new ShpInputStream((InputStream)fileInputStream2);
            EsriGraphicList esriGraphicList = null;
            try {
                esriGraphicList = shpInputStream.getGeometry(nArray);
            }
            catch (NullPointerException nullPointerException) {
                System.out.println("Error: OpenMap was not able to correctly read the shapefile\n  " + string + "\n  Check the Projection, make sure that it \n" + "is an unprojected (lat/long) format. \n" + "Sometimes this is also called WGS84  if that does not work, \n" + "I try reading in the data with the GeoTools Data class. \n " + "Data read in using the GeoToolsData class will not work with the OpenMapDisplay,  \n" + "so you will need to use the EsriDisplay class in conjunction with ArcGIS \n");
            }
            int n = 0;
            Iterator iterator = esriGraphicList.iterator();
            int n2 = 0;
            while (iterator.hasNext()) {
                ++n2;
                objectArray = new Object[1];
                oMGraphic = (OMGraphic)iterator.next();
                object = this.getSetMethodForName(clazz, "OMGraphic");
                if (object != null) {
                    objectArray[0] = oMGraphic;
                    ((Method)object).invoke(arrayList.get(n), objectArray);
                }
                if ((method = this.getSetMethodForName(clazz, "Geometry")) != null) {
                    if (!(oMGraphic instanceof EsriPolygon)) {
                        if (oMGraphic instanceof EsriPoint) {
                            oMGraphic = (EsriPoint)oMGraphic;
                        } else if (oMGraphic instanceof EsriPolyline) {
                            // empty if block
                        }
                    }
                    objectArray[0] = oMGraphic;
                    method.invoke(arrayList.get(n), objectArray);
                }
                ++n;
            }
            shxInputStream.close();
            fileInputStream.close();
            fileInputStream2.close();
            objectArray = new File(string).toURL();
            oMGraphic = new ShapefileDataStore((URL)objectArray);
            object = oMGraphic.getTypeNames()[0];
            method = oMGraphic.getFeatureSource((String)object);
            FeatureResults featureResults = method.getFeatures();
            FeatureType featureType = method.getSchema();
            featureReader = featureResults.reader();
            for (int i = 0; i < featureType.getAttributeCount(); ++i) {
                Method method2;
                AttributeType attributeType;
                if ((class$org$geotools$geometry$Geometry == null ? OpenMapData.class$("org.geotools.geometry.Geometry") : class$org$geotools$geometry$Geometry).isAssignableFrom((attributeType = featureType.getAttributeType(i)).getType()) || (method2 = this.getSetMethodForAttributeType(clazz, attributeType)) == null) continue;
                featureReader = featureResults.reader();
                int n3 = 0;
                while (featureReader.hasNext()) {
                    Feature feature = featureReader.next();
                    Object[] objectArray2 = new Object[]{feature.getAttribute(i)};
                    method2.invoke(arrayList.get(n3), objectArray2);
                    ++n3;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (featureReader != null) {
                try {
                    featureReader.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FieldNameAndType[] interrogate(String string) throws IOException {
        FieldNameAndType[] fieldNameAndTypeArray = null;
        DbaseFileReader dbaseFileReader = null;
        AbstractInterruptibleChannel abstractInterruptibleChannel = null;
        ShapeFile shapeFile = null;
        try {
            String string2 = string.substring(0, string.length() - 3);
            shapeFile = new ShapeFile(string);
            String string3 = string2 + "dbf";
            abstractInterruptibleChannel = new FileInputStream(string3).getChannel();
            dbaseFileReader = new DbaseFileReader((ReadableByteChannel)((Object)abstractInterruptibleChannel));
            DbaseFileHeader dbaseFileHeader = dbaseFileReader.getHeader();
            int n = dbaseFileReader.getHeader().getNumFields();
            fieldNameAndTypeArray = new FieldNameAndType[n + 1];
            for (int i = 0; i < n; ++i) {
                fieldNameAndTypeArray[i] = new FieldNameAndType(dbaseFileHeader.getFieldName(i), dbaseFileHeader.getFieldClass(i).getName());
            }
            String string4 = "com.bbn.openmap.dataAccess.shape.";
            string4 = shapeFile.getShapeType() == 5 ? "com.bbn.openmap.omGraphics.OMGraphic" : (shapeFile.getShapeType() == 1 ? string4 + "EsriPoint" : (shapeFile.getShapeType() == 3 ? "com.bbn.openmap.omGraphics.OMGraphic" : (shapeFile.getShapeType() == 0 ? "null" : "com.bbn.openmap.omGraphics.OMGraphic")));
            fieldNameAndTypeArray[i] = new FieldNameAndType("Geometry", "" + string4);
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (dbaseFileReader != null) {
                try {
                    dbaseFileReader.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            if (abstractInterruptibleChannel != null) {
                try {
                    abstractInterruptibleChannel.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            if (shapeFile != null) {
                try {
                    shapeFile.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        return fieldNameAndTypeArray;
    }

    public Collection sortGisAgentsbyIndex(Collection collection) {
        Collections.sort((List)collection, new Comparator(){

            public int compare(Object object, Object object2) {
                return ((GisAgent)object).getGisAgentIndex() < ((GisAgent)object2).getGisAgentIndex() ? -1 : (((GisAgent)object).getGisAgentIndex() == ((GisAgent)object2).getGisAgentIndex() ? 0 : 1);
            }
        });
        return collection;
    }

    public void writeAgents(Collection collection, String string) {
        this.writeAgents(collection, string, string);
    }

    public void writeAgents(Collection collection, String string, String string2) {
        this.writeShpUsingShp(collection, string, string2);
        FeatureArrayList featureArrayList = this.buildFeatureArrayList(collection, string);
        this.writeFeatureArrayListToDbf(collection, featureArrayList, string, string2);
    }

    public void writeShpUsingShp(Collection collection, String string, String string2) {
        try {
            Object object;
            String string3 = string.substring(0, string.length() - 3);
            String string4 = string3 + "dbf";
            String string5 = string3 + "shx";
            URL uRL = new File(string).toURL();
            URL uRL2 = new File(string4).toURL();
            URL uRL3 = new File(string5).toURL();
            EsriLayer esriLayer = new EsriLayer("createAgents", uRL2, uRL, uRL3, DrawingAttributes.DEFAULT);
            EsriGraphicList esriGraphicList = esriLayer.getEsriGraphicList();
            DbfTableModel dbfTableModel = esriLayer.getModel();
            int n = esriLayer.getType();
            Object object2 = null;
            object2 = n == 0 ? new EsriPointList() : (n == 3 ? new EsriPolylineList() : new EsriPolygonList());
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                object = (OpenMapAgent)iterator.next();
                object2.add(object.getOMGraphic());
            }
            object = string2.substring(0, string2.length() - 4);
            EsriShapeExport esriShapeExport = new EsriShapeExport((EsriGraphicList)object2, dbfTableModel, (String)object);
            esriShapeExport.setWriteDBF(false);
            esriShapeExport.export();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void writeAgentsNoShp(Collection collection, Projection projection, String string) {
        try {
            Object object;
            OMGraphicList oMGraphicList = new OMGraphicList();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                object = (OpenMapAgent)iterator.next();
                oMGraphicList.add(object.getOMGraphic());
            }
            object = string.substring(0, string.length() - 4);
            EsriShapeExport esriShapeExport = new EsriShapeExport(oMGraphicList, projection, (String)object);
            esriShapeExport.setWriteDBF(false);
            esriShapeExport.export();
            this.writeDbfFromAgents(collection, string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList writeDbfFromAgents(Collection collection, String string) {
        DBFWriter dBFWriter = null;
        try {
            Object object;
            Object object2;
            char c;
            Class<?> clazz = null;
            if (collection.size() > 0) {
                clazz = collection.iterator().next().getClass();
            }
            GisAgent gisAgent = (GisAgent)collection.iterator().next();
            String[] stringArray = gisAgent.gisPropertyList();
            String[] stringArray2 = new String[stringArray.length / 2];
            String[] stringArray3 = new String[stringArray.length / 2];
            int n = 0;
            JDBField[] jDBFieldArray = new JDBField[stringArray.length / 2];
            for (c = '\u0000'; c < stringArray.length; c += 2) {
                stringArray2[n] = stringArray[c];
                stringArray3[n] = stringArray[c + 1];
                ++n;
            }
            c = 'C';
            int n2 = 20;
            int n3 = 0;
            for (int i = 0; i < stringArray2.length; ++i) {
                object2 = clazz.getMethod(stringArray3[i], null);
                if (((Method)object2).getReturnType().getName().equals("int")) {
                    c = 'N';
                    n2 = 20;
                    n3 = 0;
                } else if (((Method)object2).getReturnType().getName().equals("double")) {
                    c = 'N';
                    n2 = 20;
                    n3 = 11;
                }
                if (((Method)object2).getReturnType().getName().equals("boolean")) {
                    c = 'L';
                    n2 = 1;
                    n3 = 0;
                }
                if (((Method)object2).getReturnType().getName().equals("java.lang.String")) {
                    c = 'C';
                    n2 = 254;
                    n3 = 0;
                }
                if (((Method)object2).getReturnType().getName().equals("float")) {
                    c = 'N';
                    n2 = 20;
                    n3 = 11;
                }
                jDBFieldArray[i] = new JDBField(stringArray2[i], c, n2, n3);
            }
            ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
            if (collection.size() > 0) {
                clazz = collection.iterator().next().getClass();
            }
            object2 = collection.iterator();
            while (object2.hasNext()) {
                object = new Object[jDBFieldArray.length];
                gisAgent = (GisAgent)object2.next();
                for (int i = 0; i < ((Object[])object).length; ++i) {
                    Method method = clazz.getMethod(stringArray3[i], null);
                    object[i] = method.invoke((Object)gisAgent, null);
                }
                arrayList.add((Object[])object);
            }
            object = string.substring(0, string.length() - 3);
            String string2 = (String)object + "dbf";
            dBFWriter = new DBFWriter(string2, jDBFieldArray);
            int n4 = arrayList.size();
            for (int i = 0; i < n4; ++i) {
                dBFWriter.addRecord((Object[])arrayList.get(i));
            }
            dBFWriter.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (dBFWriter != null) {
                try {
                    dBFWriter.close();
                }
                catch (JDBFException jDBFException) {
                    jDBFException.printStackTrace();
                }
            }
        }
        return null;
    }

    public int getShpType(String string) {
        try {
            String string2 = string.substring(0, string.length() - 3);
            String string3 = string2 + "dbf";
            String string4 = string2 + "shx";
            URL uRL = new File(string).toURL();
            URL uRL2 = new File(string3).toURL();
            URL uRL3 = new File(string4).toURL();
            EsriLayer esriLayer = new EsriLayer("createAgents", uRL2, uRL, uRL3, DrawingAttributes.DEFAULT);
            return esriLayer.getType();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return -1;
        }
    }

    public EsriGraphicList buildEsriGraphicList(Collection collection) {
        Object object = null;
        OMGraphic oMGraphic = ((OpenMapAgent)collection.iterator().next()).getOMGraphic();
        object = oMGraphic instanceof OMPoint ? new EsriPointList() : (oMGraphic instanceof EsriPolyline ? new EsriPolylineList() : new EsriPolygonList());
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            OpenMapAgent openMapAgent = (OpenMapAgent)iterator.next();
            object.add(openMapAgent.getOMGraphic());
        }
        return object;
    }

    public EsriGraphicList buildEsriGraphicList(Collection collection, int n) {
        Object object = null;
        object = n == 0 ? new EsriPointList() : (n == 3 ? new EsriPolylineList() : new EsriPolygonList());
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            OpenMapAgent openMapAgent = (OpenMapAgent)iterator.next();
            object.add(openMapAgent.getOMGraphic());
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FeatureArrayList buildFeatureArrayList(Collection collection, String string) {
        FeatureReader featureReader = null;
        try {
            Class<?> clazz = null;
            if (collection.size() > 0) {
                clazz = collection.iterator().next().getClass();
            }
            URL uRL = new File(string).toURL();
            ShapefileDataStore shapefileDataStore = new ShapefileDataStore(uRL);
            String string2 = shapefileDataStore.getTypeNames()[0];
            FeatureStore featureStore = (FeatureStore)shapefileDataStore.getFeatureSource(string2);
            FeatureResults featureResults = featureStore.getFeatures();
            FeatureArrayList featureArrayList = new FeatureArrayList();
            FeatureType featureType = featureStore.getSchema();
            int n = featureType.getAttributeCount();
            featureReader = featureResults.reader();
            Object object = collection.iterator();
            while (object.hasNext()) {
                Feature feature = featureReader.next();
                Object e = object.next();
                for (int i = 0; i < n; ++i) {
                    Method method;
                    AttributeType attributeType;
                    if ((class$org$geotools$geometry$Geometry == null ? OpenMapData.class$("org.geotools.geometry.Geometry") : class$org$geotools$geometry$Geometry).isAssignableFrom((attributeType = featureType.getAttributeType(i)).getType()) || (method = this.getGetMethodForAttributeType(clazz, attributeType)) == null) continue;
                    feature.setAttribute(i, method.invoke(e, null));
                }
                featureArrayList.add(feature);
            }
            object = featureArrayList;
            return object;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (featureReader != null) {
                try {
                    featureReader.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeFeatureArrayListToDbf(Collection collection, FeatureArrayList featureArrayList, String string, String string2) {
        DBFWriter dBFWriter = null;
        DBFReader dBFReader = null;
        try {
            String string3;
            int n;
            Object[] objectArray;
            Object object;
            Class<?> clazz = null;
            if (collection.size() > 0) {
                clazz = collection.iterator().next().getClass();
            }
            ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
            int n2 = -1;
            int n3 = ((Feature)featureArrayList.get(0)).getNumberOfAttributes();
            FeatureType featureType = ((Feature)featureArrayList.get(0)).getFeatureType();
            AttributeType[] attributeTypeArray = featureType.getAttributeTypes();
            Object object2 = collection.iterator();
            while (object2.hasNext()) {
                object = object2.next();
                Object[] objectArray2 = new Object[n3];
                objectArray = featureArrayList.getFeature(++n2).getAttributes(objectArray2);
                for (n = 0; n < n3; ++n) {
                    string3 = attributeTypeArray[n].getName();
                    Method method = this.getGetMethodForName(clazz, string3);
                    objectArray2[n] = method != null ? method.invoke(object, null) : objectArray[n];
                }
                arrayList.add(objectArray2);
            }
            object2 = string.substring(0, string.length() - 3);
            object = (String)object2 + "dbf";
            dBFReader = new DBFReader((String)object);
            int n4 = dBFReader.getFieldCount();
            objectArray = new JDBField[n4];
            for (n = 0; n < n4; ++n) {
                objectArray[n] = dBFReader.getField(n);
            }
            String string4 = string2.substring(0, string2.length() - 3);
            string3 = string4 + "dbf";
            dBFWriter = new DBFWriter(string3, (JDBField[])objectArray);
            int n5 = arrayList.size();
            for (int i = 0; i < n5; ++i) {
                Object[] objectArray3 = (Object[])arrayList.get(i);
                Object[] objectArray4 = new Object[objectArray3.length - 1];
                int n6 = 0;
                for (int j = 0; j < objectArray3.length; ++j) {
                    if (objectArray3[j] instanceof Geometry) continue;
                    objectArray4[n6] = objectArray3[j];
                    ++n6;
                }
                dBFWriter.addRecord(objectArray4);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (dBFWriter != null) {
                try {
                    dBFWriter.close();
                }
                catch (JDBFException jDBFException) {
                    jDBFException.printStackTrace();
                }
            }
        }
    }

    public HashSet getAttributeValues(String string, String string2) {
        HashSet<Object> hashSet = new HashSet<Object>();
        try {
            URL uRL = new File(string2).toURL();
            ShapefileDataStore shapefileDataStore = new ShapefileDataStore(uRL);
            String string3 = shapefileDataStore.getTypeNames()[0];
            FeatureSource featureSource = shapefileDataStore.getFeatureSource(string3);
            FeatureResults featureResults = featureSource.getFeatures();
            FeatureReader featureReader = featureResults.reader();
            while (featureReader.hasNext()) {
                Feature feature = featureReader.next();
                hashSet.add(feature.getAttribute(string));
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (IllegalAttributeException illegalAttributeException) {
            illegalAttributeException.printStackTrace();
        }
        return hashSet;
    }

    public EsriLayer getEsriLayer(String string) {
        try {
            String string2 = string.substring(0, string.length() - 3);
            String string3 = string2 + "dbf";
            String string4 = string2 + "shx";
            File file = new File(string);
            String string5 = file.getName().substring(0, file.getName().length() - 4);
            URL uRL = file.toURL();
            URL uRL2 = new File(string3).toURL();
            URL uRL3 = new File(string4).toURL();
            EsriLayer esriLayer = new EsriLayer(string5, uRL2, uRL, uRL3);
            return esriLayer;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public float[] getExtents(String string) {
        EsriLayer esriLayer = this.getEsriLayer(string);
        return esriLayer.getEsriGraphicList().getExtents();
    }

    public float[] getExtents(EsriGraphicList esriGraphicList) {
        return esriGraphicList.getExtents();
    }

    public float[] getExtents(OMGraphic oMGraphic) {
        if (oMGraphic instanceof EsriGraphic) {
            return ((EsriGraphic)oMGraphic).getExtents();
        }
        if (oMGraphic instanceof OMPoint) {
            float[] fArray = new float[]{((OMPoint)oMGraphic).getLat(), ((OMPoint)oMGraphic).getLon()};
            return fArray;
        }
        if (oMGraphic instanceof OMPoly) {
            EsriPolygon esriPolygon = EsriPolygon.convert((OMPoly)((OMPoly)oMGraphic));
            return esriPolygon.getExtents();
        }
        return null;
    }

    public LatLonPoint getCenter(EsriGraphic esriGraphic) {
        return this.getCenter(esriGraphic.getExtents());
    }

    public LatLonPoint getCenter(EsriGraphicList esriGraphicList) {
        return this.getCenter(esriGraphicList.getExtents());
    }

    public LatLonPoint getCenter(OpenMapAgent openMapAgent) {
        OMGraphic oMGraphic = openMapAgent.getOMGraphic();
        if (oMGraphic instanceof EsriGraphic) {
            return this.getCenter(((EsriGraphic)oMGraphic).getExtents());
        }
        return null;
    }

    public LatLonPoint getCenter(float[] fArray) {
        LatLonPoint latLonPoint = new LatLonPoint();
        latLonPoint.setLatitude((fArray[0] + fArray[2]) / 2.0f);
        latLonPoint.setLongitude((fArray[1] + fArray[3]) / 2.0f);
        return latLonPoint;
    }

    public LatLonPoint getCenter(String string) {
        float[] fArray = this.getExtents(string);
        if (fArray == null) {
            return null;
        }
        return this.getCenter(fArray);
    }

    public double getArea(OMGraphic oMGraphic) {
        if (oMGraphic instanceof OMPoly) {
            Vector<Geo> vector = new Vector<Geo>();
            float[] fArray = ((OMPoly)oMGraphic).getLatLonArray();
            for (int i = 0; i < fArray.length; i += 2) {
                Geo geo = new Geo((double)fArray[i], (double)fArray[i + 1]);
                vector.add(geo);
            }
            Enumeration enumeration = vector.elements();
            return Geo.area(enumeration);
        }
        return 0.0;
    }

    public double getArea(EsriGraphic esriGraphic) {
        if (esriGraphic instanceof OMPoly) {
            Vector<Geo> vector = new Vector<Geo>();
            float[] fArray = ((OMPoly)esriGraphic).getLatLonArray();
            for (int i = 0; i < fArray.length; i += 2) {
                Geo geo = new Geo((double)fArray[i], (double)fArray[i + 1]);
                vector.add(geo);
            }
            Enumeration enumeration = vector.elements();
            return Geo.area(enumeration);
        }
        return 0.0;
    }

    public Method getSetMethodForAttributeType(Class clazz, AttributeType attributeType) {
        if (attributeType.getName().equalsIgnoreCase("the_geom")) {
            return null;
        }
        Method method = null;
        Method[] methodArray = clazz.getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            if (!methodArray[i].getName().equalsIgnoreCase("set" + attributeType.getName())) continue;
            return methodArray[i];
        }
        return method;
    }

    public Method getSetMethodForName(Class clazz, String string) {
        if (string.equalsIgnoreCase("the_geom")) {
            return null;
        }
        Method method = null;
        Method[] methodArray = clazz.getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            if (!methodArray[i].getName().equalsIgnoreCase("set" + string)) continue;
            return methodArray[i];
        }
        return method;
    }

    public Method getGetMethodForName(Class clazz, String string) {
        if (string.equalsIgnoreCase("the_geom")) {
            return null;
        }
        Method method = null;
        try {
            method = clazz.getMethod("get" + string, null);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            String string2 = Character.toUpperCase(string.charAt(0)) + string.substring(1);
            try {
                method = clazz.getMethod("get" + string2, null);
            }
            catch (NoSuchMethodException noSuchMethodException2) {
                // empty catch block
            }
        }
        return method;
    }

    public Method getGetMethodForAttributeType(Class clazz, AttributeType attributeType) {
        if (attributeType.getName().equalsIgnoreCase("the_geom")) {
            return null;
        }
        Method method = null;
        String string = attributeType.getName();
        try {
            method = clazz.getMethod("get" + string, null);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            String string2 = Character.toUpperCase(string.charAt(0)) + string.substring(1);
            try {
                method = clazz.getMethod("get" + string2, null);
            }
            catch (NoSuchMethodException noSuchMethodException2) {
                // empty catch block
            }
        }
        return method;
    }

    public int getAttributePosition(String string, FeatureType featureType) {
        AttributeType[] attributeTypeArray = featureType.getAttributeTypes();
        for (int i = 0; i < attributeTypeArray.length; ++i) {
            if (!attributeTypeArray[i].getName().equalsIgnoreCase(string)) continue;
            return i;
        }
        return -1;
    }
}

