/*
 * Decompiled with CFR 0.152.
 */
package ilog.solver.xpl;

import ilog.concert.IloException;
import ilog.concert.IloModel;
import ilog.concert.IloRuntimeException;
import ilog.concert.IloSolverException;
import ilog.concert.model.IlcModel;
import ilog.solver.IlcConstraint;
import ilog.solver.IlcGoal;
import ilog.solver.IlcIntExpr;
import ilog.solver.IlcIntVar;
import ilog.solver.IlcRevInt;
import ilog.solver.IlcSolver;
import java.io.PrintStream;
import java.util.Iterator;

public class IlcExplainer {
    public static int ShowNothing = 0;
    public static int ShowDecisions = 1;
    public static int ShowDomains = 2;
    public static int ShowResult = 3;
    public static int ShowInit = 4;
    static int meb = 10;
    static int neb = 1000;
    static int oeb = 10;

    public IlcModel why(IlcSolver ilcSolver, IloModel iloModel, IlcConstraint ilcConstraint) throws IloException {
        return this.whyNot(ilcSolver, iloModel, ilcSolver.not(ilcConstraint));
    }

    public IlcModel whyFail(IlcSolver ilcSolver, IloModel iloModel) throws IloException {
        return this.whyNot(ilcSolver, iloModel, null);
    }

    public IlcModel whyNot(IlcSolver ilcSolver, IloModel iloModel, IlcConstraint ilcConstraint) throws IloException {
        DetectAndBacktrack detectAndBacktrack = new DetectAndBacktrack(ilcSolver, iloModel, ilcConstraint);
        if (ilcSolver.solve(detectAndBacktrack)) {
            throw new IloSolverException.NoExplanation(ilcConstraint);
        }
        return detectAndBacktrack.getConflict();
    }

    static void hp(IloModel iloModel, IlcConstraint ilcConstraint, String string) throws IloException {
        ilcConstraint.setName(string);
        iloModel.add(ilcConstraint);
    }

    static void gp(int n2, int n3) throws IloException {
        IlcSolver ilcSolver = new IlcSolver();
        IlcIntExpr[] ilcIntExprArray = ilcSolver.intVarArray(n2, 0, 1000000000);
        IlcIntVar ilcIntVar = ilcSolver.intVar(0, 1000000000, "y");
        IloModel iloModel = ilcSolver.model();
        IlcExplainer.hp(iloModel, ilcSolver.eq((IlcIntExpr)ilcIntVar, ilcSolver.sum(ilcIntExprArray)), "y = sum(x)");
        IlcExplainer.hp(iloModel, ilcSolver.lt((IlcIntExpr)ilcIntVar, n3), "y < " + n3);
        int n4 = 1;
        int n5 = 0;
        while (n5 < n2) {
            IlcExplainer.hp(iloModel, ilcSolver.eq(ilcIntExprArray[n5], n4), "x[" + n5 + "] = " + n4);
            n4 *= 2;
            ++n5;
        }
        try {
            IlcExplainer ilcExplainer = new IlcExplainer();
            IlcModel ilcModel = ilcExplainer.whyFail(ilcSolver, iloModel);
            System.out.println("explanation for fail: ");
            Iterator iterator = ilcModel.iterator();
            while (iterator.hasNext()) {
                Object e2 = iterator.next();
                System.out.println("  " + e2);
            }
            System.out.println("");
        }
        catch (IloSolverException.NoExplanation noExplanation) {
            System.out.println("no fail");
        }
    }

    public static void main(String[] stringArray) throws Exception {
        IlcExplainer.gp(10, 1);
        IlcExplainer.gp(10, 15);
        IlcExplainer.gp(10, 16);
        IlcExplainer.gp(10, 17);
        IlcExplainer.gp(30, 268697867);
    }

    public class TestAndDivide
    extends ExplainGoal {
        public TestAndDivide(IlcSolver ilcSolver, IloModel iloModel, IlcConstraint ilcConstraint) {
            super(ilcSolver, iloModel, ilcConstraint);
        }

        int qt() {
            int n2 = this._depth.getValue();
            int n3 = this._currentTestDepth.getValue();
            if (n3 > n2) {
                throw new Error("DetectAndDivide: testDepth > depth");
            }
            if (n3 < n2) {
                return (n2 + n3) / 2;
            }
            return (n2 + this._previousTestDepth.getValue()) / 2;
        }
    }

    public class DetectAndDivide
    extends ExplainGoal {
        public DetectAndDivide(IlcSolver ilcSolver, IloModel iloModel, IlcConstraint ilcConstraint) {
            super(ilcSolver, iloModel, ilcConstraint);
        }

        int qt() {
            int n2 = this._depth.getValue();
            int n3 = this._currentTestDepth.getValue();
            if (n3 > n2) {
                throw new Error("DetectAndDivide: testDepth > depth");
            }
            if (n3 < n2) {
                return (n2 + n3) / 2;
            }
            return this._previousTestDepth.getValue();
        }
    }

    public class DetectAndBacktrack
    extends ExplainGoal {
        public DetectAndBacktrack(IlcSolver ilcSolver, IloModel iloModel, IlcConstraint ilcConstraint) {
            super(ilcSolver, iloModel, ilcConstraint);
        }

        int qt() {
            return this._depth.getValue() - 1;
        }
    }

    public class DetectAndRestart
    extends ExplainGoal {
        public DetectAndRestart(IlcSolver ilcSolver, IloModel iloModel, IlcConstraint ilcConstraint) {
            super(ilcSolver, iloModel, ilcConstraint);
        }

        int qt() {
            return 1;
        }
    }

    public abstract class ExplainGoal
    extends IlcGoal {
        private int ksb = 0;
        private PrintStream lsb = null;
        private IlcSolver msb = null;
        private IloModel nsb = null;
        private IlcGoal osb = null;
        private IlcConstraint psb = null;
        private gb qsb = null;
        private int rsb;
        private IlcConstraint[] ssb = null;
        private IlcRevInt tsb = null;
        protected IlcRevInt _currentTestDepth = null;
        protected IlcRevInt _previousTestDepth = null;
        protected IlcRevInt _depth;
        protected int _lastLeftDepth;
        protected int _maxDepth;
        protected int _backtrackDepth;

        public ExplainGoal(IlcSolver ilcSolver, IloModel iloModel) {
            this(ilcSolver, iloModel, null);
        }

        public ExplainGoal(IlcSolver ilcSolver, IloModel iloModel, IlcConstraint ilcConstraint) {
            this.msb = ilcSolver;
            this.nsb = iloModel;
            this.psb = ilcConstraint;
            this.osb = null;
            this.ssb = new IlcConstraint[meb];
            this.tsb = new IlcRevInt(0);
            this._currentTestDepth = new IlcRevInt(1);
            this._previousTestDepth = new IlcRevInt(1);
            this._depth = new IlcRevInt(0);
            this.qsb = new gb(this.nsb, neb, oeb);
            this.init();
        }

        public void init() {
            this.rsb = 0;
            this._backtrackDepth = Integer.MAX_VALUE;
            this._lastLeftDepth = 0;
            this._maxDepth = Integer.MAX_VALUE;
        }

        public int getTraceLevel() {
            return this.ksb;
        }

        public void setTraceLevel(int n2) {
            this.ksb = n2;
        }

        public IloModel getConstraints() {
            return this.nsb;
        }

        public IlcConstraint getQuery() {
            return this.psb;
        }

        public IlcSolver getSolver() {
            return this.msb;
        }

        public IlcGoal getGoal() {
            return this.osb;
        }

        public PrintStream getTraceStream() {
            return this.lsb;
        }

        public void setTraceStream(PrintStream printStream) {
            this.lsb = printStream;
        }

        public void showState() {
        }

        public String constraintToString(IlcConstraint ilcConstraint) {
            if (ilcConstraint.getName() != null) {
                return ilcConstraint.getName();
            }
            return ilcConstraint.toString();
        }

        void vt() {
            if (this.osb == null) {
                return;
            }
            try {
                if (!this.msb.solve(this.osb, true)) {
                    this.msb.fail();
                }
            }
            catch (IloException iloException) {
                // empty catch block
            }
        }

        void xt(IlcConstraint ilcConstraint) {
            if (this.ssb.length <= this.rsb) {
                IlcConstraint[] ilcConstraintArray = new IlcConstraint[2 * this.rsb];
                int n2 = 0;
                while (n2 < this.rsb) {
                    ilcConstraintArray[n2] = this.ssb[n2];
                    ++n2;
                }
                this.ssb = ilcConstraintArray;
            }
            this.ssb[this.rsb] = ilcConstraint;
            ++this.rsb;
        }

        public IlcModel getConflict() throws IloException {
            IlcModel ilcModel = new IlcModel();
            int n2 = this.rsb - 1;
            while (n2 >= 0) {
                ilcModel.add(this.ssb[n2]);
                --n2;
            }
            return ilcModel;
        }

        abstract int qt();

        public void addToSolver(IlcConstraint ilcConstraint) throws IloException {
            this.msb.add(ilcConstraint);
        }

        IlcConstraint pt() {
            if (!this.qsb.hasNext()) {
                return null;
            }
            IlcConstraint ilcConstraint = (IlcConstraint)this.qsb.next();
            int n2 = this._depth.getValue() + 1;
            this._depth.setValue(this.msb, n2);
            this._lastLeftDepth = n2;
            if (n2 >= this._maxDepth) {
                if (this.ksb != ShowNothing) {
                    this.lsb.println(n2 + ": at max depth " + this.constraintToString(ilcConstraint));
                }
                this.msb.fail();
            }
            return ilcConstraint;
        }

        public IlcGoal execute(IlcSolver ilcSolver) {
            this.init();
            if (this.ksb == ShowInit) {
                this.lsb.println("*** background state ***");
                this.showState();
            }
            if (this.psb == null) {
                return new FindConflictGoal();
            }
            return ilcSolver.or(ilcSolver.and(new ExploreGoal(this.psb), new FindConflictGoal()), (IlcGoal)new bk(), 1);
        }

        class gb
        implements Iterator {
            int mc = 0;
            Iterator[] nc;
            Iterator oc;
            int pc;
            IlcConstraint[] qc;
            IlcRevInt rc;

            public gb(IloModel iloModel, int n2, int n3) {
                this.nc = new Iterator[n3];
                this.rc = new IlcRevInt(0);
                this.pc = 0;
                this.qc = new IlcConstraint[n2];
                this.z(iloModel);
                this.addNextConstraint();
            }

            void z(IloModel iloModel) {
                if (this.nc.length <= this.mc) {
                    Iterator[] iteratorArray = new Iterator[2 * this.mc];
                    int n2 = 0;
                    while (n2 < this.mc) {
                        iteratorArray[n2] = this.nc[n2];
                        ++n2;
                    }
                    this.nc = iteratorArray;
                }
                this.nc[this.mc] = this.oc = iloModel.iterator();
                ++this.mc;
            }

            void x() {
                --this.mc;
                this.oc = this.mc > 0 ? this.nc[this.mc - 1] : null;
            }

            /*
             * Exception decompiling
             */
            public void addNextConstraint() {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: CONTINUE without a while class org.benf.cfr.reader.bytecode.analysis.parse.statement.AssignmentSimple
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.GotoStatement.getTargetStartBlock(GotoStatement.java:102)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.IfStatement.getStructuredStatement(IfStatement.java:110)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.getStructuredStatementPlaceHolder(Op03SimpleStatement.java:550)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:727)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }

            void y(IlcConstraint ilcConstraint) {
                if (this.qc.length <= this.pc) {
                    IlcConstraint[] ilcConstraintArray = new IlcConstraint[2 * this.pc];
                    int n2 = 0;
                    while (n2 < this.pc) {
                        ilcConstraintArray[n2] = this.qc[n2];
                        ++n2;
                    }
                    this.qc = ilcConstraintArray;
                }
                this.qc[this.pc] = ilcConstraint;
                ++this.pc;
            }

            public boolean hasNext() {
                return this.rc.getValue() < this.pc;
            }

            public Object next() {
                int n2 = this.rc.getValue();
                IlcConstraint ilcConstraint = this.qc[n2++];
                this.rc.setValue(ExplainGoal.this.msb, n2);
                if (n2 >= this.pc) {
                    this.addNextConstraint();
                }
                return ilcConstraint;
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        }

        class bk
        extends IlcGoal {
            bk() {
            }

            public IlcGoal execute(IlcSolver ilcSolver) {
                if (ExplainGoal.this.ksb == ShowResult) {
                    try {
                        int n2 = 0;
                        while (n2 < ExplainGoal.this.rsb) {
                            ExplainGoal.this.addToSolver(ExplainGoal.this.ssb[n2]);
                            ++n2;
                        }
                        ExplainGoal.this.lsb.println("*** argument state ***");
                        ExplainGoal.this.showState();
                    }
                    catch (IloException iloException) {
                        // empty catch block
                    }
                }
                ilcSolver.fail();
                return null;
            }
        }

        public class FindConflictGoal
        extends IlcGoal {
            public IlcGoal execute(IlcSolver ilcSolver) {
                IlcConstraint ilcConstraint = ExplainGoal.this.pt();
                if (ilcConstraint == null) {
                    if (ExplainGoal.this.ksb == ShowDomains || ExplainGoal.this.ksb == ShowResult) {
                        ExplainGoal.this.lsb.println("*** explainable state ***");
                        ExplainGoal.this.showState();
                    }
                    return null;
                }
                int n2 = ExplainGoal.this._depth.getValue();
                return ilcSolver.and(ilcSolver.or((IlcGoal)new ExploreGoal(ilcConstraint), (IlcGoal)new TestGoal(ilcConstraint), n2), this);
            }
        }

        public class TestGoal
        extends IlcGoal {
            IlcConstraint eqb;

            public TestGoal(IlcConstraint ilcConstraint) {
                this.eqb = ilcConstraint;
            }

            public IlcGoal execute(IlcSolver ilcSolver) {
                try {
                    int n2 = ExplainGoal.this._depth.getValue();
                    if (n2 > ExplainGoal.this._backtrackDepth) {
                        ExplainGoal.this.msb.fail();
                    }
                    int n3 = ExplainGoal.this._lastLeftDepth;
                    ExplainGoal.this._lastLeftDepth = n2;
                    if (n3 == n2) {
                        ExplainGoal.this._maxDepth = n2;
                        if (ExplainGoal.this.ksb != ShowNothing) {
                            ExplainGoal.this.lsb.println(n2 + ": culprit " + ExplainGoal.this.constraintToString(this.eqb));
                        }
                        ExplainGoal.this.xt(this.eqb);
                        ExplainGoal.this._backtrackDepth = ExplainGoal.this.qt();
                        if (ExplainGoal.this.ksb == ShowDomains) {
                            ExplainGoal.this.showState();
                        }
                        ExplainGoal.this.msb.fail();
                    }
                    if (n3 <= n2) {
                        throw new Error("TestGoal: oldLastLeftDepth <= depth");
                    }
                    int n4 = ExplainGoal.this._currentTestDepth.getValue();
                    if (n4 > n2) {
                        throw new Error("TestGoal: testDepth > depth");
                    }
                    if (n4 < n2) {
                        ExplainGoal.this._previousTestDepth.setValue(ExplainGoal.this.msb, n4);
                        ExplainGoal.this._currentTestDepth.setValue(ExplainGoal.this.msb, n2);
                    }
                    ExplainGoal.this._backtrackDepth = ExplainGoal.this.qt();
                    int n5 = ExplainGoal.this.tsb.getValue();
                    int n6 = ExplainGoal.this.rsb - 1;
                    while (n6 >= n5) {
                        IlcConstraint ilcConstraint = ExplainGoal.this.ssb[n6];
                        if (ExplainGoal.this.ksb != ShowNothing) {
                            ExplainGoal.this.lsb.println(n2 + ": test " + ExplainGoal.this.constraintToString(ilcConstraint));
                            if (ExplainGoal.this.ksb == ShowDomains) {
                                ExplainGoal.this.showState();
                            }
                        }
                        ExplainGoal.this.addToSolver(ilcConstraint);
                        --n6;
                    }
                    ExplainGoal.this.vt();
                    ExplainGoal.this.tsb.setValue(ExplainGoal.this.msb, ExplainGoal.this.rsb);
                    if (n3 == n2 + 1) {
                        if (ExplainGoal.this.ksb != ShowNothing) {
                            ExplainGoal.this.lsb.println(n2 + ": culprit " + ExplainGoal.this.constraintToString(this.eqb));
                        }
                        ExplainGoal.this._maxDepth = n2;
                        ExplainGoal.this.xt(this.eqb);
                        if (ExplainGoal.this.ksb == ShowDomains) {
                            ExplainGoal.this.showState();
                        }
                        ExplainGoal.this.msb.fail();
                    }
                    ExplainGoal.this._backtrackDepth = Integer.MAX_VALUE;
                    return ExplainGoal.this.msb.or((IlcGoal)new ExploreGoal(this.eqb), (IlcGoal)new TestGoal(this.eqb), n2);
                }
                catch (IloException iloException) {
                    throw new IloRuntimeException(iloException.getMessage());
                }
            }
        }

        public class ExploreGoal
        extends IlcGoal {
            private IlcConstraint rz = null;

            public ExploreGoal(IlcConstraint ilcConstraint) {
                this.rz = ilcConstraint;
            }

            public IlcGoal execute(IlcSolver ilcSolver) {
                try {
                    if (ExplainGoal.this.ksb != ShowNothing) {
                        ExplainGoal.this.lsb.println(ExplainGoal.this._depth.getValue() + ": try " + ExplainGoal.this.constraintToString(this.rz));
                    }
                    ExplainGoal.this.addToSolver(this.rz);
                    ExplainGoal.this.vt();
                    return null;
                }
                catch (IloException iloException) {
                    throw new IloRuntimeException(iloException.getMessage());
                }
            }
        }
    }
}

