/*
 * Decompiled with CFR 0.152.
 */
package ilog.concert.model;

import ilog.concert.IloCollectionDomain;
import ilog.concert.IloDiscreteDomain;
import ilog.concert.IloDomain;
import ilog.concert.IloException;
import ilog.concert.model.IlcDomain;

public abstract class IlcCollectionDomain
extends IlcDomain
implements IloCollectionDomain {
    int myb = 0;
    int nyb = Integer.MAX_VALUE;
    IloDiscreteDomain oyb = null;

    public boolean includes(IloDomain iloDomain) throws IloException {
        IloCollectionDomain iloCollectionDomain = (IloCollectionDomain)iloDomain;
        if (this.myb > iloCollectionDomain.getCardMin() || this.nyb < iloCollectionDomain.getCardMax()) {
            return false;
        }
        return this.oyb.includes(iloCollectionDomain.getTarget());
    }

    public int getCardMin() {
        return this.myb;
    }

    public int getCardMax() {
        return this.nyb;
    }

    public IloDiscreteDomain getTarget() {
        return this.oyb;
    }

    public void setCardRange(int n2, int n3) throws IloException {
        if (n2 > n3) {
            throw new IloException("Invalid cardinality bounds definition.");
        }
        this.myb = n2;
        this.nyb = n3;
    }

    public void setCardMin(int n2) throws IloException {
        this.myb = n2;
        if (this.myb > this.nyb) {
            throw new IloException("Invalid cardinality bounds definition.");
        }
    }

    public void setCardMax(int n2) throws IloException {
        this.nyb = n2;
        if (this.nyb < this.myb) {
            throw new IloException("Invalid cardinality bounds definition.");
        }
    }

    public void setTarget(IloDiscreteDomain iloDiscreteDomain) {
        this.oyb = iloDiscreteDomain;
    }

    public int getSize() {
        return this.oyb.getSize();
    }

    public IlcCollectionDomain(int n2, int n3, IloDiscreteDomain iloDiscreteDomain) throws IloException {
        if (iloDiscreteDomain instanceof IloCollectionDomain) {
            throw new IloException("Composition of collection-domains not supported.");
        }
        if (n2 > n3) {
            throw new IloException("Invalid cardinality for collection domain.");
        }
        if (iloDiscreteDomain == null) {
            throw new IloException("Build collection domain with no target.");
        }
        this.myb = n2 < 0 ? 0 : n2;
        this.nyb = n3 < 0 ? 0 : n3;
        this.oyb = iloDiscreteDomain;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        stringBuffer.append(this.myb);
        if (this.myb != this.nyb) {
            stringBuffer.append("..");
            stringBuffer.append(this.nyb);
        }
        stringBuffer.append("] ");
        stringBuffer.append(this.oyb.toString());
        return stringBuffer.toString();
    }
}

