/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.plot.plotml;

import com.microstar.xml.XmlException;
import ptolemy.plot.Plot;
import ptolemy.plot.plotml.PlotBoxMLParser;

public class PlotMLParser
extends PlotBoxMLParser {
    protected boolean _bars = false;
    protected boolean _connected = true;
    protected int _currentDataset = -1;
    protected double _currentPointCount = 0.0;

    protected PlotMLParser() {
    }

    public PlotMLParser(Plot plot) {
        super(plot);
    }

    protected void _addPoint(boolean bl, String string) throws Exception {
        double d;
        String string2 = (String)this._attributes.get("x");
        if (string2 == null) {
            d = this._currentPointCount;
            this._currentPointCount += 1.0;
        } else {
            d = Double.valueOf(string2);
        }
        String string3 = (String)this._attributes.get("y");
        this._checkForNull(string3, "No y value for element \"" + string + "\"");
        double d2 = Double.valueOf(string3);
        String string4 = (String)this._attributes.get("lowErrorBar");
        String string5 = (String)this._attributes.get("highErrorBar");
        if (string4 == null && string5 == null) {
            ((Plot)this._plot).addPoint(this._currentDataset, d, d2, bl);
        } else {
            double d3 = string4 != null ? Double.valueOf(string4) : d;
            double d4 = string5 != null ? Double.valueOf(string5) : d;
            ((Plot)this._plot).addPointWithErrorBars(this._currentDataset, d, d2, d3, d4, bl);
        }
    }

    public void endElement(String string) throws Exception {
        super.endElement(string);
        if (string.equals("dataset")) {
            ((Plot)this._plot).setBars(this._bars);
            ((Plot)this._plot).setConnected(this._connected);
        }
    }

    public void startDocument() {
        super.startDocument();
        this._currentDataset = -1;
        this._currentPointCount = 0.0;
    }

    public void startElement(String string) throws XmlException {
        try {
            if (string.equals("barGraph")) {
                String string2 = (String)this._attributes.get("width");
                String string3 = (String)this._attributes.get("offset");
                if (string2 == null || string3 == null) {
                    ((Plot)this._plot).setBars(true);
                } else {
                    double d = Double.valueOf(string2);
                    double d2 = Double.valueOf(string3);
                    ((Plot)this._plot).setBars(d, d2);
                }
            } else if (string.equals("dataset")) {
                String string4;
                String string5;
                String string6;
                ++this._currentDataset;
                this._currentPointCount = 0.0;
                String string7 = (String)this._attributes.get("connected");
                if (string7 != null) {
                    if (string7.equals("no")) {
                        ((Plot)this._plot).setConnected(false);
                    } else {
                        ((Plot)this._plot).setConnected(true);
                    }
                }
                if ((string6 = (String)this._attributes.get("marks")) != null) {
                    ((Plot)this._plot).setMarksStyle(string6, this._currentDataset);
                }
                if ((string5 = (String)this._attributes.get("name")) != null) {
                    ((Plot)this._plot).addLegend(this._currentDataset, string5);
                }
                if ((string4 = (String)this._attributes.get("stems")) != null) {
                    if (string4.equals("yes")) {
                        ((Plot)this._plot).setImpulses(true, this._currentDataset);
                    } else {
                        ((Plot)this._plot).setImpulses(false, this._currentDataset);
                    }
                }
            } else if (string.equals("default")) {
                String string8;
                String string9 = (String)this._attributes.get("connected");
                if (string9.equals("yes")) {
                    ((Plot)this._plot).setConnected(true);
                    this._connected = true;
                } else {
                    ((Plot)this._plot).setConnected(false);
                    this._connected = false;
                }
                String string10 = (String)this._attributes.get("marks");
                if (string10 != null) {
                    ((Plot)this._plot).setMarksStyle(string10);
                }
                if ((string8 = (String)this._attributes.get("stems")).equals("no")) {
                    ((Plot)this._plot).setImpulses(false);
                } else {
                    ((Plot)this._plot).setImpulses(true);
                }
            } else if (string.equals("m")) {
                this._addPoint(false, string);
            } else if (string.equals("move")) {
                this._addPoint(false, string);
            } else if (string.equals("p")) {
                this._addPoint(true, string);
            } else if (string.equals("point")) {
                this._addPoint(true, string);
            } else if (string.equals("reuseDatasets")) {
                ((Plot)this._plot).setReuseDatasets(true);
            } else {
                super.startElement(string);
            }
        }
        catch (Exception exception) {
            if (exception instanceof XmlException) {
                throw (XmlException)exception;
            }
            String string11 = "XML element \"" + string + "\" triggers exception:\n  " + exception.toString();
            throw new XmlException(string11, this._currentExternalEntity(), this._parser.getLineNumber(), this._parser.getColumnNumber());
        }
        this._attributes.clear();
    }
}

