/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.parameter;

import java.util.Vector;
import uchicago.src.sim.engine.AddIncrementer;
import uchicago.src.sim.engine.ListIncrementer;
import uchicago.src.sim.parameter.Parameter;

public class NumericParameter
extends Parameter {
    private InitVals initVals = new InitVals();

    public void setStart(double d) {
        this.initVals.setStart(d);
    }

    public void setEnd(double d) {
        this.initVals.setEnd(d);
    }

    public void setIncr(double d) {
        this.initVals.setIncr(d);
        this.incrementer = this.initVals.getIncrementer();
        this.setParameterType(0);
    }

    public void setStart(Object object) {
        Double d = (Double)object;
        this.setStart(d);
    }

    public void setEnd(Object object) {
        Double d = (Double)object;
        this.setEnd(d);
    }

    public void setIncr(Object object) {
        Double d = (Double)object;
        this.setIncr(d);
    }

    public void setList(Vector vector) {
        super.setList(vector);
        this.incrementer = new ListIncrementer(vector);
    }

    public boolean isComplete() {
        return this.incrementer != null;
    }

    public boolean increment() {
        boolean bl = false;
        if (this.hasChildren()) {
            for (int i = 0; i < this.subParams.size(); ++i) {
                NumericParameter numericParameter = (NumericParameter)this.subParams.elementAt(i);
                if (!numericParameter.increment()) {
                    bl = this.incrementMe();
                    break;
                }
                bl = true;
            }
        } else {
            bl = this.incrementMe();
        }
        return bl;
    }

    private boolean incrementMe() {
        boolean bl = false;
        if (this.numRunsIndex > this.numRuns) {
            this.numRunsIndex = 1L;
            bl = this.isConstant() ? false : this.incrementer.increment();
        } else {
            bl = true;
        }
        ++this.numRunsIndex;
        return bl;
    }

    public String getStringValue() {
        return this.incrementer.getStringValue();
    }

    public Object getValue() {
        return this.incrementer.getValue();
    }

    public Object getStart() {
        return new Double(this.initVals.getStart());
    }

    public Object getEnd() {
        return new Double(this.initVals.getEnd());
    }

    public Object getIncr() {
        return new Double(this.initVals.getIncr());
    }

    class InitVals {
        private double start;
        private double end;
        private double incr;
        boolean startSet = false;
        boolean endSet = false;
        boolean incrSet = false;

        InitVals() {
        }

        public void setStart(double d) {
            this.start = d;
            this.startSet = true;
        }

        public void setEnd(double d) {
            this.end = d;
            this.endSet = true;
        }

        public void setIncr(double d) {
            this.incr = d;
            this.incrSet = true;
        }

        public AddIncrementer getIncrementer() {
            if (this.startSet && this.endSet && this.incrSet) {
                return new AddIncrementer(this.start, this.end, this.incr);
            }
            throw new IllegalArgumentException("Not all values expliciltly set");
        }

        public double getEnd() {
            return this.end;
        }

        public double getIncr() {
            return this.incr;
        }

        public double getStart() {
            return this.start;
        }
    }
}

