/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.network;

import cern.colt.matrix.impl.DenseDoubleMatrix1D;
import cern.colt.matrix.impl.DenseDoubleMatrix2D;
import java.util.List;
import uchicago.src.sim.network.AbstractAdjacencyMatrix;

public class AdjacencyDoubleMatrix
extends AbstractAdjacencyMatrix {
    private DenseDoubleMatrix2D matrix;

    public AdjacencyDoubleMatrix(int n, int n2) {
        this.matrix = new DenseDoubleMatrix2D(n, n2);
    }

    public AdjacencyDoubleMatrix(List list) {
        this.matrix = new DenseDoubleMatrix2D(list.size(), list.size());
        this.labels = list;
    }

    public AdjacencyDoubleMatrix(DenseDoubleMatrix2D denseDoubleMatrix2D) {
        this.matrix = denseDoubleMatrix2D;
    }

    public AdjacencyDoubleMatrix(double[][] dArray) {
        this.matrix = new DenseDoubleMatrix2D(dArray);
    }

    public void setMatrix(DenseDoubleMatrix2D denseDoubleMatrix2D) {
        this.matrix = denseDoubleMatrix2D;
    }

    public void setMatrix(double[][] dArray) {
        this.matrix = new DenseDoubleMatrix2D(dArray);
    }

    public DenseDoubleMatrix1D getRow(int n) {
        return (DenseDoubleMatrix1D)this.matrix.viewRow(n);
    }

    public double getDensity() {
        double d = this.matrix.zSum();
        return d / (double)this.matrix.rows() * (double)(this.matrix.rows() - 1);
    }

    public double getAvgDegree() {
        double d = 0.0;
        for (int i = 0; i < this.matrix.rows(); ++i) {
            for (int j = 0; j < this.matrix.columns(); ++j) {
                d += this.matrix.getQuick(i, j);
            }
        }
        return d / (double)this.matrix.rows();
    }

    public void set(int n, int n2, double d) {
        this.matrix.setQuick(n, n2, d);
    }

    public double get(int n, int n2) {
        return this.matrix.getQuick(n, n2);
    }

    public int rows() {
        return this.matrix.rows();
    }

    public int columns() {
        return this.matrix.columns();
    }

    public String matrixToString() {
        String string = this.matrix.toString();
        int n = string.indexOf("\n");
        return string.substring(n + 1, string.length());
    }

    public String toString() {
        String string = "Matrix Name: " + this.matrixLabel + "\n";
        string = string + "Matrix Labels: ";
        for (int i = 0; i < this.labels.size(); ++i) {
            string = i == 0 ? string + (String)this.labels.get(i) : string + ", " + (String)this.labels.get(i);
        }
        string = string + "\nComment: " + this.comment;
        return string + "\nAvg Degree: " + this.getAvgDegree() + "\n" + this.matrix.toString();
    }
}

