/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.analysis;

import java.awt.Color;
import uchicago.src.sim.analysis.NetSequenceGraph;
import uchicago.src.sim.analysis.Sequence;

public class NetSeqTableRow {
    protected String name;
    protected Sequence sequence;
    protected Color color;
    protected boolean show = false;
    protected boolean hasRun = false;
    protected int markType = 9;

    public NetSeqTableRow(String string, Sequence sequence, Color color) {
        this.name = string;
        this.sequence = sequence;
        this.color = color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setShow(boolean bl) {
        this.show = bl;
    }

    public void setMarkType(int n) {
        this.markType = n;
    }

    public void setHasRun(boolean bl) {
        this.hasRun = bl;
    }

    public Object getValueAt(int n) {
        switch (n) {
            case 0: {
                return this.name;
            }
            case 1: {
                return new Boolean(this.show);
            }
            case 2: {
                return this.color;
            }
            case 3: {
                return new Integer(this.markType);
            }
        }
        throw new IllegalArgumentException("invalid column index");
    }

    public static Class getClassAt(int n) {
        switch (n) {
            case 0: {
                return String.class;
            }
            case 1: {
                return Boolean.class;
            }
            case 2: {
                return Color.class;
            }
            case 3: {
                return Integer.class;
            }
        }
        throw new IllegalArgumentException("invalid column index");
    }

    public boolean isEditable() {
        return !this.hasRun;
    }

    public void addSequence(NetSequenceGraph netSequenceGraph) {
        if (!this.hasRun && this.show) {
            netSequenceGraph.addSequence(this.name, this.sequence, this.color, this.markType);
            this.hasRun = true;
        }
    }

    public void addSequence(NetSequenceGraph netSequenceGraph, String string) {
        if (!this.hasRun && this.show) {
            this.name = string;
            netSequenceGraph.addSequence(string, this.sequence, this.color, this.markType);
            this.hasRun = true;
        }
    }

    public void addSequence(NetSequenceGraph netSequenceGraph, String string, Color color) {
        if (!this.hasRun && this.show) {
            this.name = string;
            this.color = color;
            netSequenceGraph.addSequence(string, this.sequence, color, this.markType);
            this.hasRun = true;
        }
    }

    public void addSequence(NetSequenceGraph netSequenceGraph, String string, int n) {
        if (!this.hasRun && this.show) {
            this.name = string;
            this.markType = n;
            netSequenceGraph.addSequence(string, this.sequence, this.color, n);
            this.hasRun = true;
        }
    }

    public void addSequence(NetSequenceGraph netSequenceGraph, String string, Color color, int n) {
        if (!this.hasRun && this.show) {
            this.name = string;
            this.color = color;
            this.markType = n;
            netSequenceGraph.addSequence(string, this.sequence, color, n);
            this.hasRun = true;
        }
    }
}

