/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.collection;

import uchicago.src.collection.BinaryNode;

public class RangeMap {
    public static final int BLACK = 0;
    public static final int RED = 1;
    private BinaryNode header;
    private BinaryNode nullNode = new BinaryNode();
    private BinaryNode current;
    private BinaryNode parent;
    private BinaryNode grand;
    private BinaryNode great;

    public RangeMap() {
        this.header = new BinaryNode();
        this.header.key = Double.NEGATIVE_INFINITY;
        this.header.left = this.header.right = this.nullNode;
        this.nullNode.right = this.header.right;
        this.nullNode.left = this.header.right;
    }

    public void clear() {
        this.clear(this.header);
        this.header.right = this.nullNode;
        this.header.left = this.nullNode;
    }

    private void clear(BinaryNode binaryNode) {
        if (binaryNode != this.nullNode) {
            this.clear(binaryNode.left);
            this.clear(binaryNode.right);
            binaryNode.left = null;
            binaryNode.right = null;
        }
    }

    public void print() {
        this.print(this.header);
    }

    public void print(BinaryNode binaryNode) {
        if (binaryNode != this.nullNode) {
            System.out.println();
            System.out.println("node: " + binaryNode.key);
            if (binaryNode.left != this.nullNode) {
                System.out.println("\tnode.left: " + binaryNode.left.key);
            }
            if (binaryNode.right != this.nullNode) {
                System.out.println("\tnode.right: " + binaryNode.right.key);
            }
            System.out.println();
            this.print(binaryNode.left);
            this.print(binaryNode.right);
        }
    }

    public Object get(double d) {
        BinaryNode binaryNode = this.current = this.header.right;
        BinaryNode binaryNode2 = null;
        while (binaryNode != this.nullNode) {
            this.current = binaryNode;
            if (d < this.current.key) {
                binaryNode = this.current.left;
                continue;
            }
            binaryNode2 = this.current;
            binaryNode = this.current.right;
        }
        if (this.current == this.nullNode) {
            return null;
        }
        if (this.current.key > d) {
            return binaryNode2 == null ? null : binaryNode2.element;
        }
        return this.current.element;
    }

    public void put(double d, Object object) {
        this.parent = this.grand = this.header;
        this.current = this.grand;
        this.nullNode.key = d;
        while (this.current.key != d) {
            this.great = this.grand;
            this.grand = this.parent;
            this.parent = this.current;
            BinaryNode binaryNode = this.current = d < this.current.key ? this.current.left : this.current.right;
            if (this.current.left.color != 1 || this.current.right.color != 1) continue;
            this.reorient(d);
        }
        if (this.current != this.nullNode) {
            System.out.println("key: " + d);
            String string = "Invalid Key: another object alreay inserted with key";
            throw new IllegalArgumentException(string);
        }
        this.current = new BinaryNode(d, object, this.nullNode, this.nullNode);
        if (d < this.parent.key) {
            this.parent.left = this.current;
        } else {
            this.parent.right = this.current;
        }
        this.reorient(d);
    }

    public boolean isEmpty() {
        return this.header.right == this.nullNode;
    }

    private void reorient(double d) {
        this.current.color = 1;
        this.current.left.color = 0;
        this.current.right.color = 0;
        if (this.parent.color == 1) {
            this.grand.color = 1;
            if (d < this.grand.key != d < this.parent.key) {
                this.parent = this.rotate(d, this.grand);
            }
            this.current = this.rotate(d, this.great);
            this.current.color = 0;
        }
        this.header.right.color = 0;
    }

    private BinaryNode rotate(double d, BinaryNode binaryNode) {
        if (d < binaryNode.key) {
            binaryNode.left = d < binaryNode.left.key ? this.rotateWithLeftChild(binaryNode.left) : this.rotateWithRightChild(binaryNode.left);
            return binaryNode.left;
        }
        binaryNode.right = d < binaryNode.right.key ? this.rotateWithLeftChild(binaryNode.right) : this.rotateWithRightChild(binaryNode.right);
        return binaryNode.right;
    }

    private BinaryNode rotateWithLeftChild(BinaryNode binaryNode) {
        BinaryNode binaryNode2 = binaryNode.left;
        binaryNode.left = binaryNode2.right;
        binaryNode2.right = binaryNode;
        return binaryNode2;
    }

    private BinaryNode rotateWithRightChild(BinaryNode binaryNode) {
        BinaryNode binaryNode2 = binaryNode.right;
        binaryNode.right = binaryNode2.left;
        binaryNode2.left = binaryNode;
        return binaryNode2;
    }
}

