/*
 * Decompiled with CFR 0.152.
 */
package ilog.solver;

import ilog.concert.IloCPModeler;
import ilog.concert.IloConstraint;
import ilog.concert.IloCopyManager;
import ilog.concert.IloCopyable;
import ilog.concert.IloException;
import ilog.concert.IloIntBagVar;
import ilog.concert.IloIntSetVar;
import ilog.solver.IlcConstraint;
import ilog.solver.IlcDemon;
import ilog.solver.IlcIntBagVar;
import ilog.solver.IlcIntSetVar;
import ilog.solver.IlcIterator;
import ilog.solver.IlcPPropagator;
import ilog.solver.IlcSolver;
import ilog.solver.ao;
import ilog.solver.kh;

class kg
extends IlcConstraint {
    protected IlcIntSetVar _set;
    protected IlcIntBagVar _bag;

    public kg(IloIntSetVar iloIntSetVar, IloIntBagVar iloIntBagVar) {
        this._set = (IlcIntSetVar)iloIntSetVar;
        this._bag = (IlcIntBagVar)iloIntBagVar;
    }

    public synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("map(");
        stringBuffer.append(this._set);
        stringBuffer.append(", ");
        stringBuffer.append(this._bag);
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public IloCopyable makeCopy(IloCopyManager iloCopyManager) throws IloException {
        IloIntSetVar iloIntSetVar = (IloIntSetVar)iloCopyManager.getCopy(this._set);
        IloIntBagVar iloIntBagVar = (IloIntBagVar)iloCopyManager.getCopy(this._bag);
        IloCPModeler iloCPModeler = (IloCPModeler)iloCopyManager.getModeler();
        IloConstraint iloConstraint = iloCPModeler.map(iloIntSetVar, iloIntBagVar);
        iloConstraint.setName(this.getName());
        return iloConstraint;
    }

    public void needCopy(IloCopyManager.Check check) throws IloCopyManager.Check {
        this._set.needCopy(check);
        this._bag.needCopy(check);
    }

    public Object extract(IlcSolver ilcSolver) throws IloException {
        IlcIntSetVar ilcIntSetVar = this._set;
        IlcIntBagVar ilcIntBagVar = this._bag;
        kh kh2 = (kh)ilcIntSetVar.getExtracted(ilcSolver);
        ao ao2 = (ao)ilcIntBagVar.getExtracted(ilcSolver);
        return new cl(kh2, ao2);
    }

    static final class cl
    extends IlcPPropagator {
        kh fx;
        ao gx;

        public cl(kh kh2, ao ao2) {
            this.fx = kh2;
            this.gx = ao2;
        }

        public void metaPost(IlcDemon ilcDemon) {
            this.fx.whenDomain(ilcDemon);
            int n2 = 0;
            while (n2 < this.gx.seb.length) {
                this.gx.seb[n2].whenRange(ilcDemon);
                ++n2;
            }
        }

        public void post() {
            this.fx.whenDomain(new tt());
            int n2 = 0;
            while (n2 < this.gx.seb.length) {
                this.gx.seb[n2].whenRange(new pb(n2));
                ++n2;
            }
            this.fx.getCardinality().whenRange(new pab());
            this.gx.getCardinality().whenRange(new zw());
        }

        public void propagate() {
            int n2;
            IlcIterator ilcIterator = this.fx.getDomainPossibleIterator();
            while (ilcIterator.hasNext()) {
                n2 = ilcIterator.nextValue();
                if (this.fx.isDomainRequired(n2)) {
                    this.gx.addDomainRequired(n2);
                    continue;
                }
                if (this.gx.isDomainPossible(n2)) continue;
                this.fx.removeDomainPossible(n2);
            }
            n2 = this.gx.ueb;
            while (n2 <= this.gx.veb) {
                if (this.gx.isDomainPossible(n2)) {
                    if (this.gx.isDomainRequired(n2)) {
                        this.fx.addDomainRequired(n2);
                    } else if (!this.fx.isDomainPossible(n2)) {
                        this.gx.removeDomainPossible(n2);
                    }
                }
                ++n2;
            }
        }

        public boolean isViolated() {
            IlcIterator ilcIterator = this.fx.getDomainRequiredIterator();
            while (ilcIterator.hasNext()) {
                if (this.gx.isDomainPossible(ilcIterator.nextValue())) continue;
                return true;
            }
            int n2 = this.gx.ueb;
            while (n2 <= this.gx.veb) {
                if (this.gx.isDomainRequired(n2) && !this.fx.isDomainPossible(n2)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        public synchronized String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("map(");
            stringBuffer.append(this.fx);
            stringBuffer.append(", ");
            stringBuffer.append(this.gx);
            stringBuffer.append(")");
            return stringBuffer.toString();
        }

        final class pb
        extends IlcDemon {
            private int od;

            pb(int n2) {
                this.od = n2;
            }

            public void propagate() {
                if (cl.this.gx.seb[this.od].getDomainMin() > 0) {
                    cl.this.fx.addDomainRequired(cl.this.gx.getValue(this.od));
                } else if (cl.this.gx.seb[this.od].getDomainMax() <= 0) {
                    cl.this.fx.removeDomainPossible(cl.this.gx.getValue(this.od));
                }
            }
        }

        final class tt
        extends IlcDemon {
            tt() {
            }

            public void propagate() {
                IlcIterator ilcIterator = cl.this.fx.getDeltaPossibleIterator();
                while (ilcIterator.hasNext()) {
                    cl.this.gx.removeDomainPossible(ilcIterator.nextValue());
                }
                ilcIterator = cl.this.fx.getDeltaRequiredIterator();
                while (ilcIterator.hasNext()) {
                    cl.this.gx.addDomainRequired(ilcIterator.nextValue());
                }
            }
        }

        final class zw
        extends IlcDemon {
            zw() {
            }

            public void propagate() {
                if (cl.this.gx.getCardinality().getDomainMin() > 0) {
                    cl.this.fx.getCardinality().setDomainMin(1);
                }
                cl.this.fx.getCardinality().setDomainMax(cl.this.gx.getCardinality().getDomainMax());
            }
        }

        final class pab
        extends IlcDemon {
            pab() {
            }

            public void propagate() {
                cl.this.gx.getCardinality().setDomainMin(cl.this.fx.getCardinality().getDomainMin());
            }
        }
    }
}

