/*
 * Decompiled with CFR 0.152.
 */
package ilog.solver;

import ilog.concert.IloCPModeler;
import ilog.concert.IloConstraint;
import ilog.concert.IloCopyManager;
import ilog.concert.IloCopyable;
import ilog.concert.IloDecExpr;
import ilog.concert.IloException;
import ilog.concert.IloNumExpr;
import ilog.solver.IlcConstraint;
import ilog.solver.IlcDecExpr;
import ilog.solver.IlcDemon;
import ilog.solver.IlcNumExpr;
import ilog.solver.IlcPPropagator;
import ilog.solver.IlcSolver;
import ilog.solver.iv;
import ilog.solver.jh;
import ilog.solver.nm;
import ilog.solver.sv;

final class il
extends IlcConstraint {
    protected IlcDecExpr _v;
    protected IlcNumExpr _exp;

    il(IloDecExpr iloDecExpr, IloNumExpr iloNumExpr) {
        this._v = (IlcDecExpr)iloDecExpr;
        this._exp = (IlcNumExpr)iloNumExpr;
    }

    public IlcDecExpr getDecExpr() {
        return this._v;
    }

    public IlcNumExpr getNumExpr() {
        return this._exp;
    }

    public Object extract(IlcSolver ilcSolver) throws IloException {
        nm nm2 = this._v.getPNumExp(ilcSolver);
        if (nm2 instanceof sv) {
            sv sv2 = (sv)nm2;
            nm nm3 = this._exp.getPNumExp(ilcSolver);
            return new oq(sv2, nm3);
        }
        iv iv2 = (iv)nm2;
        nm nm4 = this._exp.getPNumExp(ilcSolver);
        return new dz(iv2, nm4);
    }

    public synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("decLtRound(");
        stringBuffer.append(this._v);
        stringBuffer.append(",");
        stringBuffer.append(this._exp);
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public IloCopyable makeCopy(IloCopyManager iloCopyManager) throws IloException {
        IloCPModeler iloCPModeler = (IloCPModeler)iloCopyManager.getModeler();
        IloConstraint iloConstraint = iloCPModeler.ltRound((IloDecExpr)iloCopyManager.getCopy(this._v), (IloNumExpr)iloCopyManager.getCopy(this._exp));
        iloConstraint.setName(this.getName());
        return iloConstraint;
    }

    public void needCopy(IloCopyManager.Check check) throws IloCopyManager.Check {
        this._v.needCopy(check);
        this._exp.needCopy(check);
    }

    static class dz
    extends IlcPPropagator {
        final iv jbc;
        final nm kbc;

        public dz(iv iv2, nm nm2) {
            this.jbc = iv2;
            this.kbc = nm2;
        }

        public void metaPost(IlcDemon ilcDemon) {
            this.kbc.whenRange(ilcDemon);
        }

        public void post() {
            this.kbc.whenRange(this);
        }

        public void propagate() {
            this.kbc.setDomainLB(this.jbc.getDomainRoundStrictLB());
        }

        public boolean isViolated() {
            return this.kbc.getDomainUB() < this.jbc.getDomainRoundStrictLB();
        }

        public IlcPPropagator makeOpposite() {
            return new jh.lw(this.jbc, this.kbc);
        }

        public synchronized String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("decLtRound PLtCstRound(");
            stringBuffer.append(this.jbc);
            stringBuffer.append(",");
            stringBuffer.append(this.kbc);
            stringBuffer.append(")");
            return stringBuffer.toString();
        }
    }

    static final class oq
    extends IlcPPropagator {
        final sv cjb;
        final nm djb;

        public oq(sv sv2, nm nm2) {
            this.cjb = sv2;
            this.djb = nm2;
        }

        public void metaPost(IlcDemon ilcDemon) {
            this.cjb.whenRange(ilcDemon);
            this.djb.whenRange(ilcDemon);
        }

        public void post() {
            this.cjb.whenRange(this);
            this.djb.whenRange(this);
        }

        public void propagate() {
            this.cjb.setDomainRoundStrictUB(this.djb.getDomainUB());
            this.djb.setDomainLB(this.cjb.getDomainRoundStrictLB());
        }

        public boolean isViolated() {
            return this.djb.getDomainUB() < this.cjb.getDomainRoundStrictLB();
        }

        public IlcPPropagator makeOpposite() {
            return new jh.kx(this.cjb, this.djb);
        }

        public synchronized String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("decLtRound PLtRound(");
            stringBuffer.append(this.cjb);
            stringBuffer.append(",");
            stringBuffer.append(this.djb);
            stringBuffer.append(")");
            return stringBuffer.toString();
        }
    }
}

