/*
 * Decompiled with CFR 0.152.
 */
package ilog.solver;

import ilog.concert.IloCPModeler;
import ilog.concert.IloConstraint;
import ilog.concert.IloCopyManager;
import ilog.concert.IloCopyable;
import ilog.concert.IloException;
import ilog.solver.IlcConstraint;
import ilog.solver.IlcPPropagator;
import ilog.solver.IlcSolver;
import ilog.solver.j;
import ilog.solver.vg;

public final class IlcIfThenElse
extends IlcConstraint {
    private IlcConstraint bd;
    private IlcConstraint cd;
    private IlcConstraint dd;

    public IlcIfThenElse(IloConstraint iloConstraint, IloConstraint iloConstraint2, IloConstraint iloConstraint3) {
        this.bd = (IlcConstraint)iloConstraint;
        this.cd = (IlcConstraint)iloConstraint2;
        this.dd = (IlcConstraint)iloConstraint3;
    }

    public IloConstraint getCondition() {
        return this.bd;
    }

    public IloConstraint getThen() {
        return this.cd;
    }

    public IloConstraint getElse() {
        return this.dd;
    }

    public Object extract(IlcSolver ilcSolver) throws IloException {
        IlcPPropagator ilcPPropagator = this.bd.getPropagator(ilcSolver);
        IlcPPropagator ilcPPropagator2 = this.cd.getPropagator(ilcSolver);
        IlcPPropagator ilcPPropagator3 = this.dd.getPropagator(ilcSolver);
        if (ilcPPropagator.isViolated()) {
            return ilcPPropagator3;
        }
        IlcPPropagator ilcPPropagator4 = ilcPPropagator.getOpposite();
        if (ilcPPropagator4.isViolated()) {
            return ilcPPropagator2;
        }
        IlcPPropagator ilcPPropagator5 = ilcPPropagator2.getOpposite();
        if (ilcPPropagator3.isViolated()) {
            if (ilcPPropagator5.isViolated()) {
                return ilcPPropagator;
            }
            return new j.yy(ilcSolver, ilcPPropagator, ilcPPropagator2);
        }
        IlcPPropagator ilcPPropagator6 = ilcPPropagator3.getOpposite();
        if (ilcPPropagator2.isViolated()) {
            if (ilcPPropagator6.isViolated()) {
                return ilcPPropagator4;
            }
            return new j.yy(ilcSolver, ilcPPropagator4, ilcPPropagator3);
        }
        vg.co co2 = new vg.co(ilcSolver, ilcPPropagator, ilcPPropagator3);
        if (ilcPPropagator5.isViolated()) {
            return co2;
        }
        vg.co co3 = new vg.co(ilcSolver, ilcPPropagator4, ilcPPropagator2);
        if (ilcPPropagator6.isViolated()) {
            return co3;
        }
        return new j.yy(ilcSolver, co3, co2);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ifThenElse(");
        stringBuffer.append(this.bd);
        stringBuffer.append(", ");
        stringBuffer.append(this.cd);
        stringBuffer.append(", ");
        stringBuffer.append(this.dd);
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public IloCopyable makeCopy(IloCopyManager iloCopyManager) throws IloException {
        IloCPModeler iloCPModeler = (IloCPModeler)iloCopyManager.getModeler();
        IloConstraint iloConstraint = iloCPModeler.ifThenElse((IloConstraint)iloCopyManager.getCopy(this.bd), (IloConstraint)iloCopyManager.getCopy(this.cd), (IloConstraint)iloCopyManager.getCopy(this.dd));
        iloConstraint.setName(this.getName());
        return iloConstraint;
    }

    public void needCopy(IloCopyManager.Check check) throws IloCopyManager.Check {
        this.bd.needCopy(check);
        this.cd.needCopy(check);
        this.dd.needCopy(check);
    }
}

