object IntSetSpec:

  def isSorted(l: List[Int]): Boolean =
    l match
      case List()|List(_) => true
      case x :: y :: ys => x < y && isSorted(y :: ys)

  def insert(x: Int, l: List[Int]): List[Int] = {
    require(isSorted(l))
    l match
      case List() => List(x)
      case y :: ys =>
        if x < y then x :: l
        else if x > y then y :: insert(x, ys)
        else l
  }.ensuring(res => isSorted(res) && res.contains(x))

  abstract class IntSet
  case class Empty() extends IntSet
  case class Node(left: IntSet, elem: Int, right: IntSet) extends IntSet

  extension (s: IntSet)
    def contains(x: Int): Boolean =
      s match
        case Empty() => false
        case Node(l, e, r) =>
          if x < e then l.contains(x)
          else if x > e then r.contains(x)
          else true

    def incl(x: Int): IntSet = {
      require(s.valid)
      s match
        case Empty() => Node(Empty(), x, Empty())
        case Node(l, e, r) =>
          if x < e then Node(l.incl(x), e, r)
          else if x > e then Node(l, e, r.incl(x))
          else s
    }.ensuring(_.valid)

    def toList: List[Int] = s match
      case Empty() => Nil
      case Node(l, e, r) => l.toList ++ List(e) ++ r.toList

    def valid: Boolean = isSorted(s.toList)
  end extension
    
  @main def test =
    val testList = insert(25, List(10,20,30,40))
    println(testList)

    val t1 = Node(Empty(), 2, Empty())
    val t2 = Node(Empty(), 5, Empty())
    val ts = Node(t1, 3, t2)
    print(ts)
    println(f"is sorted: ${isSorted(ts.toList)}")
    val ts1 = ts.incl(4)
    println(ts1)
    val tu = Node(t2, 3, t1)
    print(tu)
    println(f"is sorted: ${isSorted(tu.toList)}")
    // val tu1 = tu.incl(4) // crashes

end IntSetSpec