object IntSetMkTree:
  abstract class IntSet
  case class Empty() extends IntSet
  case class Node(left: IntSet, elem: Int, right: IntSet) extends IntSet

  extension (s: IntSet)
    def size: Int =
      s match
        case Empty() => 0
        case Node(l, _, r) => l.size + 1 + r.size

  // makes a tree
  def mkTree(n: Int): IntSet =
    if n <= 0 then Empty()    
    else 
      val t1: IntSet = mkTree(n-1)
      Node(t1, n, t1)

  @main def test =
    val t = mkTree(16)
    println(f"t.size = ${t.size}")
    val tt = mkTree(30)
    println(f"made a tree with mkTree(30). Computig size:")
    println(f"tt.size = ${tt.size}")


end IntSetMkTree