object IntSetCopying:
  abstract class IntSet
  case class Empty() extends IntSet
  case class Node(left: IntSet, elem: Int, right: IntSet) extends IntSet:
    var mark: Boolean = false

  extension (s: IntSet)
    def incl(x: Int): IntSet =
      s match
        case Empty() => Node(Empty(), x, Empty())
        case Node(l, e, r) =>
          if x < e then Node(l.incl(x), e, r)
          else if x > e then Node(l, e, r.incl(x))
          else s

  def mkTreeRange(from: Int, until: Int): IntSet =
    if from == until then Empty()
    else if from + 1 == until then Node(Empty(),from*2,Empty())
    else
      val mid = from + (until - from)/2
      Node(mkTreeRange(from, mid), mid*2, 
           mkTreeRange(mid + 1, until))

  def markTree(t: IntSet): Unit =
    t match
      case Empty() => ()
      case n@Node(l, e, r) => 
        n.mark = true
        markTree(l)
        markTree(r)        

  extension[T](t: IntSet)
    def toDraw: Vector[String] = // note that down is left
      t match
        case Empty() => Vector("─")
        case n@Node(l, elem, r) =>
          val ls = r.toDraw
          val rs = l.toDraw      
          val p = 3* ls.size / 2 // push first subtree right for visual balance
          val width: Int = 3 
          val s0: String = elem.toString + (if !n.mark then "*" else "")
          val es: String = "─" * (width - s0.length) + s0
          val es1: String = " " * (width - 1)  
          val ls1 = Vector(es + "─"*p + ls.head) ++
                    ls.tail.map(es1 + "│" + " "*p + _)
          val rs1 = Vector(es1 + "└" + rs.head) ++
                    rs.tail.map(es1 + " " + _)
          ls1 ++ rs1
    end toDraw

  def show(t: IntSet): String = 
    t.toDraw.mkString("\n")

  @main 
  def test =
    val t2 = mkTreeRange(1, 8)
    markTree(t2) // mark nodes as old so we can see what is inserted
    val t2i9 = t2.incl(9)
    val t2i13 = t2i9.incl(13)
    println("Original tree:\n" + show(t2))
    println("After insertion  of 9:\n" + show(t2i9))
    println("After insertion  of 7:\n" + show(t2i13))
    markTree(t2i9)
    println("After insertion of 9 and marking of t2i9:\n" + show(t2i13))
  
end IntSetCopying