object Zip { // first example shown, executable version

enum List[T]:
  case Nil()
  case Cons(head: T, tail: List[T])

  def map[U](f: T => U): List[U] =
    this match
      case Nil()            => Nil()
      case Cons(head, tail) => Cons(f(head), tail.map(f))

  def size: BigInt = {
    this match
      case Nil()         => BigInt(0)
      case Cons(_, tail) => BigInt(1) + tail.size
  }.ensuring (_ >= 0)

import List.*

val nil = Nil[(Int, Boolean)]()


// [a1, a2, a3]    [b1, b2, b3]    ===>   [(a1,b1), (a2,b2), (a3, b3)]
def zip(xs: List[Int], ys: List[Boolean]): List[(Int, Boolean)] = {
  require(xs.size <= ys.size)  
  (xs, ys) match
    case (Cons(x, xs0), Cons(y, ys0)) =>
          Cons((x, y), zip(xs0, ys0))
    case _ => nil
}.ensuring (result => result.map(_._1) == xs)

val exampleCall = zip(Cons(1, Nil()), Nil())

}
