object ZipGenerous { // do not insert lines, main.tex uses firstline=...
enum List[T]:
  case Nil()
  case Cons(head: T, tail: List[T])

  def map[U](f: T => U): List[U] =
    this match
      case Nil()            => Nil()
      case Cons(head, tail) => Cons(f(head), tail.map(f))

  def size: BigInt = {
    this match
      case Nil()         => BigInt(0)
      case Cons(_, tail) => BigInt(1) + tail.size
  }.ensuring (_ >= 0)
import List.*
val nil = Nil[(Int, Boolean)]()

def zip(xs: List[Int], ys: List[Boolean]): List[(Int, Boolean)] = {   
  (xs, ys) match
    case (Cons(x, xs0), Cons(y, ys0)) =>
          Cons((x, y), zip(xs0, ys0))
    case _ => nil
}.ensuring: res => 
  (!(xs.size <= ys.size) || res.map(_._1) == xs) &&
  (!(ys.size <= xs.size) || res.map(_._2) == ys)

extension[T] (lst: List[T])
  def head: T = {
    require(lst != Nil())
    lst match // no warning for Nil case!
      case Cons(h,t) => h
  }

  def apply(n: BigInt): T = {
    require(0 <= n && n < lst.size)
    lst match // no warning for Nil case! Stainless concludes 0 < lst.size, so lst != Nil
      case Cons(h,t) => 
        if n == 0 then h else t.apply(n - 1)
  }

val testApplyOK = Cons(1, Cons(2, Cons(3, Nil()))).apply(2)    // accepted
// val testApplyNo = Cons(1, Cons(2, Cons(3, Nil()))).apply(3) // rejected

extension[T] (xs: List[T])
  def ++(ys: List[T]): List[T] = {
    xs match
      case Nil() => ys
      case Cons(h, t) => Cons(h, t ++ ys)
  }.ensuring: res =>
      res.size == xs.size + ys.size

def appendIndex[T](l1: List[T], l2: List[T], i: BigInt): Unit = {
  require(0 <= i && i < (l1 ++ l2).size)  // assumptions for theorem to be well-defined
    l1 match // proof
      case Cons(x,xs) if (i > 0) => appendIndex[T](xs, l2, i - 1) // use I.H. (recursive call)
      case _ => () // base case and i=0 - follow from axioms and function unfolding
}.ensuring: _ => 
   (l1 ++ l2)(i) == (if i < l1.size then l1(i) else l2(i - l1.size))   // theorem 

// without .size property of ++, we get failure at the call l2(i - l1.size))

extension[T] (ll: List[List[T]])
  def flatten: List[T] =
    ll match
      case Cons(h, t) => h ++ t.flatten
      case Nil() => Nil[T]()

def single[T](x: T) = Cons(x, Nil[T]())

import stainless.annotation.*
def examQuestion[T](@induct lst: List[T]): Unit = {
}.ensuring( _ => {
    val ll: List[List[T]] = lst.map(single)
    ll.flatten == lst })

}
