object ZipGenerous { // do not insert lines, main.tex uses firstline=
enum List[T]:
  case Nil()
  case Cons(head: T, tail: List[T])

  def map[U](f: T => U): List[U] =
    this match
      case Nil()            => Nil()
      case Cons(head, tail) => Cons(f(head), tail.map(f))

  def size: BigInt = {
    this match
      case Nil()         => BigInt(0)
      case Cons(_, tail) => BigInt(1) + tail.size
  }.ensuring (_ >= 0)
import List.*
val nil = Nil[(Int, Boolean)]()

def zip(xs: List[Int], ys: List[Boolean]): List[(Int, Boolean)] = {   
  (xs, ys) match
    case (Cons(x, xs0), Cons(y, ys0)) =>
          Cons((x, y), zip(xs0, ys0))
    case _ => nil
}.ensuring: res => 
  (!(xs.size <= ys.size) || res.map(_._1) == xs) &&
  (!(ys.size <= xs.size) || res.map(_._2) == ys)

extension[T] (lst: List[T])
  def head: T = {
    require(lst != Nil())
    lst match 
      case Cons(h,t) => h
  }

  def apply(n: BigInt): T = {
    require(0 <= n && n < lst.size)
    lst match 
      case Cons(h,t) => 
        if n == 0 then h else t.apply(n - 1)
  }

val testApplyOK = Cons(1, Cons(2, Cons(3, Nil()))).apply(2) // accepted
val testApplyNo = Cons(1, Cons(2, Cons(3, Nil()))).apply(3) // accepted, but will crash!

// [warn] match may not be exhaustive. // but it is, in fact, exhaustive!
// [warn] 
// [warn] It would fail on pattern case: List.Nil()
// [warn]     lst match

}
