object checkMSort {
  import org.scalacheck.*
  import Gen.*
  import Arbitrary.arbitrary
  import mSortExample.*
  import stainless.collection.*

  val genNil: Gen[List[Int]] = const(Nil[Int]())
  val genCons: Gen[List[Int]] = 
    for
      h <- arbitrary[Int]
      tail <- genList
    yield Cons[Int](h, tail)

  def genList: Gen[List[Int]] = oneOf(genNil, lzy(genCons))
  lazy given arbList: Arbitrary[List[Int]] = Arbitrary(genList)
  def tests(n: Int) = Test.Parameters.default.withMinSuccessfulTests(n)

  def mSortOK = Prop.forAll { (l: List[Int]) =>
    val res = mSort(l)
    res != Cons(123456, Nil())
  }.check(tests(5_000_000))
  // + OK, passed 5000000 tests.

  @main 
  def test1 =     
    val lists = (1 to 21).tails.toList.reverse
    lists.foreach: scalaList =>
      val list = List.fromScala(scalaList.toList)
      println(f"list = $list")
      val mSorted = mSort(list)
      println(f"mSort(list) = $mSorted")
}
