object ExampleTree:
  sealed trait Expr
  case class Variable(s: String) extends Expr
  case class Add(e1: Expr, e2: Expr) extends Expr

  extension (e1: Expr)
    def +(e2: Expr): Expr = 
        Add(e1, e2)

  @main def testTrees =
    val x = 3
    val y = 5
    val z = x + y
    println(z)              // we just add numbers

    val p = Variable("p")
    val q = Variable("q")
    val r = p + q
    println(r)              // we construct Add(p,q)
