package scalashop.common

import java.util.concurrent.*
import scala.math.sqrt
import scala.util.DynamicVariable

/** Given a function, return the time elapsed in its computation, in
  * milliseconds.
  *
  * Discards the result of the computation, but side-effects propagate.
  *
  * @param f
  *   function to time
  * @return
  *   elapsed time, in ms
  */
def measure[A](f: => A): Long =
  val t1 = System.currentTimeMillis()
  f
  val t2 = System.currentTimeMillis()
  t2 - t1
