package codebreaking

import GuessResult.*

class BullsAndCowsSolveSuite extends TimedSuite(7):
  import BullsAndCows.*

  test("BullsAndCows: Base case (1pt)"):
    assertEquals(
      BullsAndCows.Game(0).guess(List()),
      FoundSolution(List())
    )

  test("BullsAndCows: Single solution: single guess (1pt)"):
    assertEquals(
      BullsAndCows.Game(3).guess(
        List(ScoredGuess(List(1, 2, 3), Score(3, 0)))
      ),
      FoundSolution(List(1, 2, 3))
    )

  test("BullsAndCows: Single solution: two guesses, redundant (1pt)"):
    assertEquals(
      BullsAndCows.Game(3).guess(
        List(
          ScoredGuess(List(1, 2, 3), Score(3, 0)),
          ScoredGuess(List(1, 2, 3), Score(3, 0))
        )
      ),
      FoundSolution(List(1, 2, 3))
    )

  test("BullsAndCows: Single solution: two guesses, required (1pt)"):
    assertEquals(
      BullsAndCows.Game(3).guess(
        List(
          ScoredGuess(List(1, 2, 3), Score(2, 0)),
          ScoredGuess(List(5, 1, 2), Score(0, 3))
        )
      ),
      FoundSolution(List(1, 2, 5))
    )

  test("BullsAndCows: Multiple solutions (1pt)"):
    BullsAndCows.Game(4).guess(
      List(
        ScoredGuess(List(0, 0, 0, 0), Score(0, 0)),
        ScoredGuess(List(1, 1, 1, 1), Score(0, 0)),
        ScoredGuess(List(2, 2, 2, 2), Score(0, 0)),
        ScoredGuess(List(3, 3, 3, 3), Score(0, 0)),
        ScoredGuess(List(4, 4, 4, 4), Score(0, 0)),
        ScoredGuess(List(5, 5, 5, 5), Score(0, 0)),
        ScoredGuess(List(6, 6, 7, 7), Score(2, 0))
      )
    ) match
      case StillGuessing(_) => {}
      case r                => throw AssertionError(f"Unexpected response: $r")

  test("BullsAndCows: Single solution by elimination (1pt)"):
    assertEquals(
      BullsAndCows.Game(4).guess(
        List(
          ScoredGuess(List(0, 0, 0, 0), Score(0, 0)),
          ScoredGuess(List(1, 1, 1, 1), Score(0, 0)),
          ScoredGuess(List(2, 2, 2, 2), Score(0, 0)),
          ScoredGuess(List(3, 3, 3, 3), Score(0, 0)),
          ScoredGuess(List(4, 4, 4, 4), Score(0, 0)),
          ScoredGuess(List(5, 5, 5, 5), Score(0, 0)),
          ScoredGuess(List(6, 6, 7, 7), Score(2, 0)),
          ScoredGuess(List(9, 9, 9, 0), Score(0, 1)),
          ScoredGuess(List(0, 8, 8, 8), Score(0, 1))
        )
      ),
      FoundSolution(List(8, 6, 7, 9))
    )

  test("BullsAndCows: Impossible repetition (1pt)"):
    // Impossible repetition
    assertEquals(
      BullsAndCows.Game(3).guess(
        List(
          ScoredGuess(List(1, 1, 2), Score(2, 1))
        )
      ),
      NoSolution
    )

  test("BullsAndCows: No solutions (1pt)"):
    // Impossible score
    assertEquals(
      BullsAndCows.Game(3).guess(
        List(
          ScoredGuess(List(1, 1, 1), Score(0, 3))
        )
      ),
      NoSolution
    )

    // All possibilities eliminated
    assertEquals(
      BullsAndCows.Game(5).guess(
        List(
          ScoredGuess(List(0, 1, 2, 3, 4), Score(0, 0)),
          ScoredGuess(List(5, 5, 5, 5, 5), Score(0, 0))
        )
      ),
      NoSolution
    )

    // Contradictions
    assertEquals(
      BullsAndCows.Game(3).guess(
        List(
          ScoredGuess(List(1, 2, 3), Score(2, 1)),
          ScoredGuess(List(5, 1, 2), Score(0, 3))
        )
      ),
      NoSolution
    )

  test("BullsAndCows.solve(10, List(8)) (1pt)"):
    assertEquals(
      BullsAndCows.solve(10, List(8)),
      Some(List(8))
    )

  test("BullsAndCows.solve(100, List(8, 4)) (1pt)"):
    assertEquals(
      BullsAndCows.solve(100, List(8, 4)),
      Some(List(8, 4))
    )

  test("BullsAndCows.solve(16, List(1, 2, 8)) (1pt)"):
    assertEquals(
      BullsAndCows.solve(16, List(1, 2, 8)),
      Some(List(1, 2, 8))
    )

  test("BullsAndCows.solve(12, List(7, 2, 4)) (1pt)"):
    assertEquals(
      BullsAndCows.solve(12, List(7, 2, 4)),
      Some(List(7, 2, 4))
    )

  test("BullsAndCows.solve(8, List(4, 6, 1)) (1pt)"):
    assertEquals(
      BullsAndCows.solve(8, List(4, 6, 1)),
      Some(List(4, 6, 1))
    )

  test("BullsAndCows.solve(8, List(1, 5, 3, 9, 7)) (1pt)"):
    assertEquals(
      BullsAndCows.solve(8, List(1, 5, 3, 9, 7)),
      Some(List(1, 5, 3, 9, 7))
    )
