package codebreaking

class BullsAndCowsScoreSuite extends TimedSuite(7):
  import BullsAndCows.*

  test("BullsAndCows.score(List(), List()) (2pts)"):
    assertEquals(BullsAndCows.score(List(), List()), Score(0, 0))

  test("BullsAndCows.score(List(1, 2), List(1, 2)) (2pts)"):
    assertEquals(
      BullsAndCows.score(List(1, 2), List(1, 2)),
      Score(2, 0)
    )

  test("BullsAndCows.score(List(2, 1, 3), List(1, 2, 3)) (2pts)"):
    assertEquals(
      BullsAndCows.score(List(2, 1, 3), List(1, 2, 3)),
      Score(1, 2)
    )

  test("BullsAndCows.score(List(1, 2, 3, 1, 2, 3, 6), List(7, 1, 2, 3, 4, 5, 6)) (2pts)"):
    assertEquals(
      BullsAndCows.score(List(1, 2, 3, 1, 2, 3, 6), List(7, 1, 2, 3, 4, 5, 6)),
      Score(1, 3)
    )

  test("BullsAndCows.score(List(2, 1, 2, 1, 6, 7), List(1, 2, 3, 4, 6, 7)) (2pts)"):
    assertEquals(
      BullsAndCows.score(List(2, 1, 2, 1, 6, 7), List(1, 2, 3, 4, 6, 7)),
      Score(2, 2)
    )

  test("BullsAndCows.score(List(1, 3, 5, 7, 9), List(0, 2, 4, 6, 8)) (2pts)"):
    assertEquals(
      BullsAndCows.score(List(1, 3, 5, 7, 9), List(0, 2, 4, 6, 8)),
      Score(0, 0)
    )

  test("BullsAndCows.score(List(5, 2, 7, 2, 3, 3), List(5, 2, 7, 3, 4, 6)) (2pts)"):
    assertEquals(
      BullsAndCows.score(List(5, 2, 7, 2, 3, 3), List(5, 2, 7, 3, 4, 6)),
      Score(3, 1)
    )

  test("BullsAndCows.score(List.fill(10)(0), (0 to 9).toList) (2pts)"):
    assertEquals(
      BullsAndCows.score(List.fill(10)(0), (0 to 9).toList),
      Score(1, 0)
    )

  test("BullsAndCows.score((0 to 9).toList, (0 to 9).toList) (2pts)"):
    assertEquals(
      BullsAndCows.score((0 to 9).toList, (0 to 9).toList),
      Score(10, 0)
    )

  test("BullsAndCows.score((0 to 9).toList, (0 to 9).reverse.toList) (2pts)"):
    assertEquals(
      BullsAndCows.score((0 to 9).toList, (0 to 9).reverse.toList),
      Score(0, 10)
    )
