#include <iostream>
#include <vector>
#include <string>
#include <fstream>
#include <iomanip>
using namespace std;

// ======================================================================
struct Sapin {
  vector<int> corps;
  int pied;
  bool deco;
  const char dessin_corps;
  const char dessin_pied;
};

// ======================================================================
string demander_nom()
{
  string retour;
  cout << "Entrez un nom de fichier où écrire : ";
  cin >> retour;
  return retour;
}

// ======================================================================
bool ouverture(ofstream& fichier)
{
  const string nom(demander_nom());
  fichier.open(nom);
  bool err = fichier.fail();
  if (err) {
    cerr << "Error: cannot open \"" << nom << '"' << endl;
  }
  return not err;
}

// ======================================================================
void place(ofstream& fichier, int offset, char c, bool endline = true)
// pour éviter le copié-collé entre dessine_ligne et dessine_deco
{
  fichier << setfill(' ') << setw(offset+1) << c;
  if (endline) fichier << endl;
}

// ======================================================================
void dessine_ligne(ofstream& fichier, int offset, int taille, char a_dessiner)
{
  place(fichier, offset, a_dessiner, false);
  fichier << setfill(a_dessiner) << setw(taille-1) << a_dessiner << endl;
}

// ======================================================================
void dessine_trapeze(ofstream& file, int offset, int size, char c)
{
  for(int i(1); i <= size; ++i) {
    dessine_ligne(file, offset+size-i, 2*i+1, c);
  }
}

// ======================================================================
void dessine_corps(ofstream& file, vector<int> sizes, char c)
{
  for (auto size : sizes) {
    dessine_trapeze(file, sizes.back()-size, size, c);
  }
}

// ======================================================================
void dessine_rectangle(ofstream& file, int offset, int height, int width, char c)
{
  for(int i(1); i <= height; ++i) {
    dessine_ligne(file, offset, width, c);
  }
}

// ======================================================================
void dessine_deco(ofstream& fichier, int offset, char c)
{
  place(fichier, offset, '^');
  place(fichier, offset, '|');
  place(fichier, offset,  c );
}

// ======================================================================
void dessine(ofstream& fichier, Sapin const& sapin)
{
  if (sapin.deco) {
    dessine_deco(fichier, sapin.corps.back(),
                 sapin.dessin_corps);
  }

  dessine_corps(fichier, sapin.corps, sapin.dessin_corps);

  // on pourrait même faire un dessine_pied()...
  const int larg(3); // whatever...
  dessine_rectangle(fichier, 2*larg, sapin.pied, sapin.corps.back()-larg,
                     sapin.dessin_pied);
}

// ======================================================================
int main()
{
  ofstream output;

  if (ouverture(output)) {
    dessine(output,
            { { 3, 5, 9 }, // corps ; on peut aussi utiliser .corps = { 3, 5, 9 }
              3, // pied
              true, // déco
              '*', // dessin du corps
              '#' // dessin du pied
            }
            );
  }
  
  return 0;
}
