#include <iostream>
#include <vector>
#include <string>
#include <fstream>
#include <iomanip>

// nombres au hasard
#include <functional> // pour bind()
#include <random>

using namespace std;

// ======================================================================
constexpr char boule('O');
constexpr double proba_boule(0.05);

// ======================================================================
struct Sapin {
  vector<int> corps;
  int pied;
  bool deco;
  const char dessin_corps;
  const char dessin_pied;
};

// ======================================================================
bool tirage(double proba_true)
{
  random_device rd;          // utilisé ici pour la graine
  unsigned int graine(rd()); // par exemple, ou sinon de votre choix

  // choix du générateur et initialisation (graine)
  default_random_engine generateur(graine);

  uniform_real_distribution<double> distribution(0.0, 1.0);
  function<double()> draw(bind(distribution, generateur));

  if (draw() < proba_true) return true;
  return false;
}


// ======================================================================
string demander_nom()
{
  string retour;
  cout << "Entrez un nom de fichier où écrire : ";
  cin >> retour;
  return retour;
}

// ======================================================================
bool ouverture(ofstream& fichier)
{
  const string nom(demander_nom());
  fichier.open(nom);
  bool err = fichier.fail();
  if (err) {
    cerr << "Error: cannot open \"" << nom << '"' << endl;
  }
  return not err;
}

// ======================================================================
void place(ofstream& fichier, int offset, char c, bool endline = true)
// pour éviter le copié-collé entre dessine_ligne et dessine_deco
{
  fichier << setfill(' ') << setw(offset+1) << c;
  if (endline) fichier << endl;
}

// ======================================================================
void dessine_ligne(ofstream& fichier, int offset, int taille, char a_dessiner,
                   double proba = 0.0, char random = 0)
{
  if (random == 0) {
    // pas de caractère au hasard
    place(fichier, offset, a_dessiner, false);
    fichier << setfill(a_dessiner) << setw(taille-1) << a_dessiner << endl;
  } else {
    // quelques de caractères au hasard
    char c(a_dessiner);
    if (tirage(proba)) c = random;
    place(fichier, offset, a_dessiner, false);
    // on ne peut plus utiliser setfill ici à cause des char au hasard
    for (int i(2); i <= taille; ++i) {
      c = tirage(proba) ? random : a_dessiner;
      fichier << c;
    }
    fichier << endl;
  }
}

// ======================================================================
void dessine_trapeze(ofstream& file, int offset, int size, char c)
{
  for(int i(1); i <= size; ++i) {
    dessine_ligne(file, offset+size-i, 2*i+1, c, proba_boule, boule);
  }
}

// ======================================================================
void dessine_corps(ofstream& file, vector<int> sizes, char c)
{
  for (auto size : sizes) {
    dessine_trapeze(file, sizes.back()-size, size, c);
  }
}

// ======================================================================
void dessine_rectangle(ofstream& file, int offset, int height, int width, char c)
{
  for(int i(1); i <= height; ++i) {
    dessine_ligne(file, offset, width, c);
  }
}

// ======================================================================
void dessine_deco(ofstream& fichier, int offset, char c)
{
  place(fichier, offset, '^');
  place(fichier, offset, '|');
  place(fichier, offset, c  );
}

// ======================================================================
void dessine(ofstream& fichier, Sapin const& sapin)
{
  if (sapin.deco) {
    dessine_deco(fichier, sapin.corps.back(),
                 sapin.dessin_corps);
  }
  dessine_corps(fichier, sapin.corps, sapin.dessin_corps);

  // on pourrait même faire un dessine_pied()...
  const int larg(3); // whatever...
  dessine_rectangle(fichier, 2*larg, sapin.pied, sapin.corps.back()-larg,
                     sapin.dessin_pied);
}

// ======================================================================
int main()
{
  ofstream output;

  if (ouverture(output)) {
    dessine(output,
            { { 3, 5, 9 }, // corps ; on peut aussi utiliser .corps = { 3, 5, 9 }
              3, // pied
              true, // déco
              '*', // dessin du corps
              '#' // dessin du pied
            }
            );
  }
  
  return 0;
}
