
// ce qui suit est un ébauche de conception possible (en pseudo-code, seules
// les entêtes de méthodes sont présentes lorsque le corps n'est pas demandé)

class VacuumCleaner extends Animal
{

	private static double  MIN_CAPACITY_PERCENTAGE = 0.1;
	private static double  MIN_CAPACITY_TO_VACCUM_UP_ITEM = 0.5;
	private static double  PERCENTAGE_LOST_BY_STEP = 0.03;

		private int capacity;

		private final int threshold;

	// initialise le threshold à 10% de la capacité initiale
	public VacuumCleaner(int capacity, Vector2D position);

	
	//fait perdre 3% de sa capacité actuelle
	public void loseCapacity();


		Animal copy()
		{
			return new VacuumCleaner(getCapacity(), getPosition());
		}

	
	// si pas présente besoin d'un getThreshold + getCapacity 
	public bool weak()
		{
			return capacity < threshold;
		}

	// si pas présent besoin de getCapacity + constantes publiques
	public bool canVacuumUpItem();
	
	// 1 met en place le déplacement aléatoire
	public Direction move(Direction[] choices);
}

// 
// les objets oubliés: pas besoin d'une classe
// mais on peu admettre ceci 
class Item
{
	private Vector2D position;
	public Item(Vector2D position);
}

class Room extends World
{
	public Room(int[][] labyrinth); 

	private final List<VacuumCleaner> mCleaners;

	// à utiliser pour restaurer les capacités d'aspiration lors du reset
	private final List<VacuumCleaner> mInitCleaners;

	// positions des dalles propres
	private final List<Vector2D> cleaned;

	//List<Item> ausi OK si classe Item
	private final List<Vector2D> items;

	//addItem(Item item); // aussi OK
	public void addItem(Vector2D position);

	// addCleaner(VacuumCleaner cleaner); // aussi OK
	public void addCleaner(int id, int capacity, Vector2D position);

	public void removeCleaner(VacuumCleaner cleaner);

	public void removeItem(Vector2D position);

	// ajoute une position à cleaned
	public addClean(Vector2D position);

	// (on peut admettre un getCleaned)
	public  boolean isClean(Vector2D position);

	//  (on peut admettre un getItems())
	public boolean hasItem(Vector2D position);

	// 
	int itemCount();

	//
	List<Vector2D> positionItems();
	
	// 1(bonus)
	boolean allVacuumWeak();
	
	// retourne la liste d'aspirateurs
	@Override
	public List<Animal> getAnimals();


	// retourne vrai si tous les aspirateurs
	// on un capacité < 10% ou que toutes les dalles sont propres
	// (cleaned.size() == cleanCount) || allVacuumWeak()
	// 
	@Override
	
	public boolean isSolved();

	@Override
	public void reset() {
		mCleaners.clear();
		for (Cleaner cleaner : mInitCleaners) {
			mCleaners.add((Cleaner) cleaner.copy());
		}
		cleaned = new ArrayList<Vector2D>();
	}
	
}

	
