// Draft de corrigé : exemple de solution attendue

// Total conception : 50 points
// Total programmation : 5 points

// 1
enum Season {
    SPRING, SUMMER, FALL, WINTER
}

// TOTAL HIERARCHIE CLIMAT =  5.5  points
/* interface Climate (aussi acceptée comme classe abstraite)
 *  0.5 pour la coquille vide de classe/interface
 *  1 pour la méthode
 * Total : 1.5 points
 */
interface Climate {
    public abstract double computeAverageTemp(Seasons s);
}

/* Classe Tropical
 * 0.5 pour la coquille vide de classe
 * 0.5 pour le lien d'implémentation ou d'héritage
 * 1 pour la redéfinition de la méthode
 * Total = 2 
 */
class Tropical implements Climate {
    @Override
    public double computeAverageTemp(Season s) {}
};

/* Classe Temperate
 * 0.5 pour la coquille vide de classe
 * 0.5 pour le lien d'implémentation ou d'héritage
 * 1 pour la redéfinition de la méthode
 * Total = 2 
 */
class Temperate implements Climate {
    @Override
    double computeAverageTemp(Season s) {}
}

// Modélisation du territoire:
/* Classe Territory
 * 1 pour la coquille vide de classe
  * 0.25pt : droit d'accès publique aux méthodes de l'interface d'utilisation
  * 0.25 pt: droit d'accès privé aux attributs
  Total : 13.5 points + 1 point en bonus
*/
class Territory {
	//0.25
    private static final double WATER_TRESHOLD = 12.0;
	// 0.25
    private static final double EVAPORATION_TRESHOLD = 2.0;
	// 1 (0.5 en bonus pour déclarer une liste au lieu de
	// ArrayList)
    private List<CellHandlder> cellHandlers;
	// 0.5
    private Climate climate;

	// 1 (dont 0.5 pourle throws)
    private void readFromFile(String fileName) throws IOException
    {}

	// 0.5
    private Season season;

	// 0.5
    private int  size;

	// 1
    public Territory(Climate climate, String fileName) {
		// corps non demandé
        super(climate);
        season = Season.SUMMER;
        cellHandlers = new ArrayList<CellHandler>;
        try {
            readFromFile(filename);
        } catch(IOException) {
            //..
        } finally {
        }

    }
	// 1
    public double arableSurface() {
        return 0.0;
    }

	//1 
    public void simulate (double dt) {
        for (CellHandler cellhandler : cellHandlers) {
            cellHandler->update(dt, this);
        }
    }

    // nécessaire pour que les cellules d'eau diffusent
	// peut aussi éventuellement être codé dans CellHandler si
    // ce dernier connait le terrain
    //utilise isOut
	// 1
    public void diffuseWaterOnNeighbors(Vector pos);

    //nécessaire pour l'évaporation de l'eau et pour faire
	//pousser les végétaux
	// 1
    public double averageTemp() {
		// corps non demandé
        return climate.computeAverageTemp();
    }

	// 1
    public void rain(double volume)
    {}


    // utilise CellHandler::getWaterQuantity
	// 1
    public double getWaterQuantityAt(Vector pos) {
        return 0.0;
    }

	// 1
    public void setSeason(Season s)
    {}


    // nécessaire pour ne pas diffuser en dehors du monde
	// 0,5 (bonus)
    boolean isOut(Vector pos) {
        return false;
    }

}


/* Classe CellHandler
   permet de gérer la superposition de 3 types de cellules
    1 pour la présence de la classe
   0.5 pour le lien implements
   0.5 pour le lien extends
   0.5 pour les droits d'accès corrects
   Total : 10.5 points
 */
class CellHandler extends Positionable implements Updatable {
	// 0.5
    private CellWater  water;
	// 0.5
    private CellGreen  green;
	//0.5
    private CellGround ground;

    // instanciation de CellGround
    // le reste à null
    // donne sa position a ses Cell
	// 1
    public CellHandler(Vector pos)
    {}

	// 0.5
	// nécessaire à l'initisalisation via fichier
    public void setGreen(); // instanciation
	// 0.5
    public void setWater();
	//
    public void setGround(); // pas indispensable

	//1
    public double getWaterQuantity() { // nécessaire pour faire pousser l'herbe
        return cellWater
    }

	//1
    public boolean isGreen() // retourne true s'il y a une cellule d'herbe et que la  quantité de'au est inférieure à
    // peut être remplacée par getGreenQuantity combiné à getWaterQuantity
    //
    {
        return false;
    }


    // pas indispensables
	// 0.25 bonus (pour modularisation)
    public void removeGreen() {
        green = null;
    }
    public void removeWater() {} // codée comme précédemment


	// 1.5 dont 0,5 pour le territoire en paramètre
    public void update(double dt, Territory owner) {
		// Corps pas demandé
        if (water != null) {
            water.update(dt, owner);
            if (water.mustBeRemoved()) {
                removeWater();
            }
        }

        if (green != null) {
            green.update(dt, owner);
			if (green.mustBeRemoved()) {
                removeGreen();
            }
        }
        // nécessaire pour la pluie : appelle increaseWaterQuantity
        // sur sa cellWater et s'il n'en a pas en crée une au préalable
		//1
        public void increaseWaterQuantity(double qty)
        {}



    }


// TOTAL HIERARCHIE DE CELL: 5.5  + 2.25 + 6.5 + 5.25 = 19.5 points
/*Classe Cell:
	  0.5 pour la coquille vide
	  0.25 pour les méthodes en publique
	  0.25 pour les attributs en private
	  0.5 pour le lien implements
	  0.5 pour le lien extends
	  0.5 pour le abstract
	  Total = 5.5
*/	
 abstract class Cell extends Positionable implements Updatable {
        // a besoin soit de sa position, soit de son CellHandler (pour remonter à la position)
		// 0.5
        public Cell(Vector pos) {}

        @Override
		// 1.5 (dont 0.5 pour le territoie en paramètre et 0.5
		// pour le abstract)
        public abstract void update(double dt, Territory ter);

        // (ou toute méthodes équivalente permettant de gérer proprement la fin de vie.
	 // 1
        public boolean mustBeRemoved() {
            return false;
        }
    };

	/* Classe WaterCell
coquille vide 0.5 dont 0.25 pour le lien d'héritage
0.25 pour les méthodes publiques
0.25 pour les attributs privés
Total : 6.5
	 */
    class WaterCell extends Cell {
		//0.5
        private double waterQuantity;
		//0.5 (+0.25 en bonus pour la mise en protégé ou private)
        private void evaporate(double dt);

		// 0.5
        public WaterCell(Vector pos) {}


        @Override
		//1
        public void update(double dt, Territory ter) {
            // diffuse autour + s'évapore en fonction de la température
            // (si totalement évaporé le update de Territory
			// fait appel à removeWater)

			// 2.5:
            ter.diffuseWaterOnNeighbors(getPosition(), 0.2*getWaterQuantity());
			// 2.5:
            if (ter.averageTemp() >  ter.EVAPORATION_TRESHOLD)
                evaporate(dt);
        }

        // nécessaire pour la pluie
		// 1
        public void increaseWaterQuantity(double qty);

		// 1
        public double getWaterQuantity(); // nécessaire pour coder CellHandler.getWaterQuantity
        @Override
		// 1
        public boolean mustBeRemoved() {
            return (waterQuantity <=0);
        }


    }
	
	/* classe GroundCell
	   coquille vide 0.5 dont 0.25 pour le lien d'héritage
	   0.25 pour les méthodes publiques
	   Total : 2.25
	 */	
    class GroundCell extends Cell {
		//0.5
        public GroundCell(Vector pos);
        @Override
		//1
        public void update(double dt, Territory ter)
        {} // ne fait rien

    }
	/* classe GreenCell
	   coquille vide 0.5 dont 0.25 pour le lien d'héritage
	   0.25 pour les méthodes publiques
	   0.25 pour les attributs privés
	   Total 5.25
	 */	
	
    class GreenCell extends  Cell {
		//0.5
		private double greenQuantity;
        // augmente/diminuee le greenQuantity en fonction du niveau
		// d'humidité
        // et de la temperature moyenne dictée par le climat

		// 1.25 (dont (0.5 pour le territoire)
		// le temps n'est pas indispensable
		// car non spécifié dans l'énoncé
        private void grow(Time dt, Territory ter) {}
		// 0.5
        public GreenCell(Vector  pos);

		// utilise Territory.getWaterQuantityAt
		// 1
        void update(Time dt, Territory ter) {
            grow(dt,ter);
        }

        @Override
		// 1
        boolean  mustBeRemoved()
        {
            return (greenQuantity <=0);
        }


    }





