% Problem 3

close all
clear all

% Load the various vectors
load pa_sequence.mat
load rx_samples.mat

% Define parameters
PAPB = 10; % PA sequences per symbol

% Find the beginning of the first full pa_sequence within the received
% samples. If your code works correctly, that should be at sample number
% 208.

% Get the minimum amount of data required to find a full pa_sequence
rx_corr = rx_samples(1:2*length(pa_sequence)-1);
R = xcorr(rx_corr, pa_sequence);

% Plot to see what we have got
figure;
stem(abs(R));
grid on;
title('The result of the correlation');

% Remove ramp up
R = R(length(rx_corr):end);
[~, ind] = max(abs(R))


% Find the beginning of the first full symbol within the received samples.
% To do that, you should look for a phase transition of roughly pi between
% the inner products of two properly chosen consecutive chunks of received
% samples with the pa_sequence. If your code works properly, you should find
% that the first complete symbol starts at sample number 1744.

found = false;
lastInnerProduct = rx_samples(ind:ind+length(pa_sequence)-1)*pa_sequence';

while ~found
    
    ind = ind + length(pa_sequence); % advance by the length of a PA
    y = rx_samples(ind:ind+length(pa_sequence)-1); % get the corresponding data

    innerProduct = y*pa_sequence';

    % For a safer estimation, we reduce the decision zone to [3*pi/4, 5*pi/4]
    % Note that angle() returns values in (-pi, pi]
    found = (abs(angle(innerProduct * conj(lastInnerProduct))) > 3*pi/4);
    lastInnerProduct = innerProduct;
    
end

index_change_phase = ind
index_start_first_symbol = mod(ind, PAPB*length(pa_sequence))


% Extract from the received samples the portion corresponding to full
% symbols and process it accordingly in order to generate the sufficient
% statistics about the transmitted data symbols. Plot the result. If your
% code works properly, you should obtain a rotated (and noisy) BPSK
% constellation.


% Trim the received samples to have full symbols
rx_samples = rx_samples(index_start_first_symbol:end);
rx_samples = rx_samples(1:end-mod(length(rx_samples), PAPB*length(pa_sequence)));

% Apply the matched filter
code = repmat(pa_sequence, 1, PAPB);
rx_data_mf = conv(rx_samples, conj(fliplr(code)));
% Remove the tails
rx_data_mf = rx_data_mf(length(code):end-length(code)+1);
% Sample the MF output
rx_dec = rx_data_mf(1:length(code):end);
received_number_of_symbols = length(rx_dec)

% Plot the constellation at the (sampled) output of the matched filter
figure;
plot(rx_dec, '*');
grid on;
title('The received constelaltion at the output of the matched filter')


% Knowing that the first transmitted symbol was a +1, estimate the phase
% introduced by the channel. If your code works properly, you should get a
% phase of about 2.07 radians.
phase_shift = angle(rx_dec(1))

% Correct for the phase rotation, take decisions in oder to estimate the
% transmitted data symbols and compute the symbol error rate (SER). If
% everything works correctly, you should get SER = 0.
rx_dec_corrected = exp(-1j*phase_shift)*rx_dec;

% Plot to see what we have got
figure;
plot(rx_dec_corrected, '*');
grid on;
title('The received constellation after the phase correction')

% Decode the symbols and compute the SER
decodedSymbols = 1 - 2*(real(rx_dec_corrected) < 0);
load tx_data_symbols.mat
SER = sum(decodedSymbols ~= tx_data_symbols)/length(tx_data_symbols)
