import numpy as np
import matplotlib.pyplot as plt
import scipy.io as sio
from scipy.signal import correlate as corr

# Problem 3

# Load the samples of caPulseDelayedWithDoppler and caPulse
rx = sio.loadmat('caPulseDelayedWithDoppler.mat')
caPulseDelayedWithDoppler = rx['caPulseDelayedWithDoppler'].flatten()

p = sio.loadmat('caPulse.mat')
caPulse = p['caPulse'].flatten()

# Define parameters
Ts = 1/4092000  # sampling time [seconds]
desiredResolution = 10  # [Hz]

# Optional paper & pencil question, for additional 4 points. You can skip
# this part and solve the problem below without answering this question.

# According to the problem statement, we can write:
# caPulseDelayedWithDoppler(t) = caPulse(t - tau)*exp(j*2*pi*fd*t), for
# some delay tau and Doppler frequency fd. Express the Fourier transform of
# caPulseDelayedWithDoppler as a function of the Fourier transform of
# caPulse. Derive then a relation between the absolute values of the two
# Fourier transforms mentioned above.

# You can write your answer to the question above on the exam sheet.

# ======================================================================

# The first task here is to estimate the Doppler frequency (fd) by
# correlating the absolute values of the Fourier transforms of
# caPulseDelayedWithDoppler and caPulse. The correlation will have its peak
# at the frequency fd.


# Choose the DFT size N so that the frequency resolution of the above
# mentioned Fourier transforms is desiredResolution (10 Hz) or better.
N = np.ceil(1/(Ts*desiredResolution))

# Compute the DFT of caPulse and caPulseDelayedWithDoppler
rFft = np.fft.fft(caPulseDelayedWithDoppler, int(N))
pFft = np.fft.fft(caPulse, int(N))

# Correlate the absolute values of the two DFTs in order to find the
# Doppler frequency. You should obtain fd = 830 Hz.
R = corr(abs(rFft), abs(pFft), 'full', 'fft')

# Plot to see how sharp is the correlation
plt.figure()
plt.plot(R)
plt.grid()
plt.title('Xcorr of the DFTs')
plt.show()


indexMax = np.argmax(R)
trueIndex = indexMax - rFft.size + 1  # +1 since Python starts indexing at 0
print('trueIndex = ', trueIndex)

# Check the resolution
frequencyResolution = 1/(N*Ts)
print('frequencyResolution = ', frequencyResolution)

# The index we have found is smaller than N/2, so we are in the positive
# frequencies. Hence, no correction is needed on the index for finding fd.
estimatedDoppler = trueIndex * frequencyResolution
print('estimatedDoppler = ', estimatedDoppler)

# Correct caPulseDelayedWithDoppler for Doppler
t = np.arange(caPulseDelayedWithDoppler.size) * Ts
rCorrectedForDoppler = caPulseDelayedWithDoppler * np.exp(-1j * 2 * np.pi * estimatedDoppler * t)

# Once caPulseDelayedWithDoppler is corrected for Doppler, one can make
# another correlation in order to estimate the delay. You should obtain a
# delay of 472 samples.
R1 = corr(rCorrectedForDoppler, caPulse, 'full', 'fft')

# Plot to see how sharp is the correlation
plt.figure()
plt.plot(abs(R1))
plt.grid()
plt.title('Xcorr for finding the delay')
plt.show()

indexMax1 = np.argmax(abs(R1))
trueIndex1 = indexMax1 - caPulse.size + 1  # +1 since Python starts indexing at 0
print('estimatedDelay = ', trueIndex1)
