% Problem 3

close all;
clear all;

% Load the samples of caPulseDelayedWithDoppler and caPulse
load caPulse.mat
load caPulseDelayedWithDoppler.mat

% Define parameters
Ts = 1/4092000; % sampling time [seconds]
desiredResolution = 10; % [Hz]


% Optional paper & pencil question, for additional 4 points. You can skip
% this part and solve the problem below without answering this question.

% According to the problem statement, we can write:
% caPulseDelayedWithDoppler(t) = caPulse(t - tau)*exp(j*2*pi*fd*t), for
% some delay tau and Doppler frequency fd. Express the Fourier transform of
% caPulseDelayedWithDoppler as a function of the Fourier transform of
% caPulse. Derive then a relation between the absolute values of the two
% Fourier transforms mentioned above.

% You can write your answer to the question above on the exam sheet. 

% ======================================================================

% The first task here is to estimate the Doppler frequency (fd) by
% correlating the absolute values of the Fourier transforms of
% caPulseDelayedWithDoppler and caPulse. The correlation will have its peak
% at the frequency fd.


% Choose the DFT size N so that the frequency resolution of the above
% mentioned Fourier transforms is desiredResolution (10 Hz) or better.
N = ceil(1/(Ts*desiredResolution))


% Compute the DFT of caPulse and caPulseDelayedWithDoppler
rFft = fft(caPulseDelayedWithDoppler, N);
pFft = fft(caPulse, N);    


% Correlate the absolute values of the two DFTs in order to find the
% Doppler frequency. You should obtain fd = 830 Hz.
R = xcorr(abs(rFft), abs(pFft));

% Plot to see how sharp is the correlation
figure;
plot(R); grid on;
title('Xcorr of the DFTs')

[~, indexMax] = max(R);
trueIndex = indexMax - length(rFft)

% Check the resolution
frequencyResolution = 1/(N*Ts)

% The index we have found is smaller than N/2, so we are in the positive
% frequencies. Hence, no correction is needed on the index for finding fd.
estimatedDoppler = trueIndex * frequencyResolution


% Correct caPulseDelayedWithDoppler for Doppler
t = (0 : length(caPulseDelayedWithDoppler)-1) * Ts;
rCorrectedForDoppler = caPulseDelayedWithDoppler .* exp(-1i*2*pi*estimatedDoppler*t);

% Once caPulseDelayedWithDoppler is corrected for Doppler, one can make
% another correlation in order to estimate the delay. You should obtain a
% delay of 472 samples.
R1 = xcorr(rCorrectedForDoppler, caPulse);

% Plot to see how sharp is the correlation
figure;
plot(abs(R1)); grid on;
title('Xcorr for finding the delay')

[~, indexMax1] = max(abs(R1));
trueIndex1 = indexMax1 - length(rCorrectedForDoppler);

estimatedDelay = trueIndex1
