import numpy as np
from numpy import linalg as LA
import warnings


def rcosdesign(beta, span, sps):
    # returns the root-raised-cosine, with unit norm

    # Verify that span * sps is even
    if (span * sps) % 2 != 0:
        raise ValueError('rcosdesign:wrongInputValues', 'Product of SPS and SPAN must be even.')

    # compute the time line
    M = span * sps
    no_samples = np.round(M/2)
    t = np.arange(-no_samples, no_samples + 1, 1) / sps
    # print(t)

    y = np.zeros(t.shape, dtype=np.float)

    if beta == 0:
        y = np.sinc(t)
    else:
        # implement the formula from Bixio's PDC book
        # first take care of the special cases (when the denominator is zero)

        # mask = np.argwhere(t == 0.25 / beta)  # testing exact equality does not quite work!
        mask = np.isclose(np.abs(t), 0.25 / beta)
        # print(mask)

        y[mask] = (beta / np.sqrt(2)) * ((1 + 2/np.pi)*np.sin(np.pi/(4*beta)) + (1 - 2/np.pi)*np.cos(np.pi/(4*beta)))
        # then the non-special case
        scaling_factor = (4 * beta) / np.pi
        nominator = np.cos((1 + beta) * np.pi * t[~mask]) + (((1 - beta) * np.pi) / (4 * beta)) * np.sinc((1 - beta) * t[~mask])
        denominator = 1 - np.square(4 * beta * t[~mask])
        y[~mask] = scaling_factor * (nominator / denominator)

    # normalize to have unit norm
    y = y / LA.norm(y)

    return y
