% demodulate an AM signal

close all;
clear all;

% s.mat contains the samples of an AM signal. The AM signal is sampled at
% frequency fs, and the carrier frequency is fc.
load s.mat
fs = 1e4; % Hz
fc = 210; % Hz
l = length(s);

% you may want to plot s to see that it is an AM signal
tfplot(s, fs, 's', 'An AM signal');

% create a local carrier, not yet sychronized
timeline = 0:1/fs:(l-1)/fs;
unCarrier = cos(2*pi*fc*timeline); % unsynchronized carrier

% find out by how much you have to shift the local carrier so that 
% it is in phase with the carrier of the received signal
x = xcorr(s,unCarrier);

figure; stem(x); grid on; xlabel('index'); ylabel('xcorr'); title('xcorr(Rx signal, Unsynchronized carrier)');

[~, index] = max(x);
shiftInSamples = index - l % number of samples by which we have to shift the carrier

% create a new carrier that lines up with the carrier in s
shiftInTime = shiftInSamples/fs; % 
% if c(t) is the unsynchronized carrier, we want c(t-shiftInTime)
shiftedTimeline = timeline - shiftInTime; % 
synchedCarrier = cos(2*pi*fc*shiftedTimeline); % we are computing c(t-shiftInTime)

% you may want to plot the synchedCarrier and verify that it lines up
% correctly.
figure;
subplot(2,1,1);
plot(s(1:100)/max(abs(s(1:100)))); grid on; title('Carrier of the Rx signal');

subplot(2,1,2);
plot(synchedCarrier(1:100)); grid on; title('Synchronized carrier');
 
% Optional bonus points: if you get stuck at the other problems, you can come 
% back here and get some extra points by continuing below this line. 
% The purpose is to demodulate the AM signal. 

y = s .* synchedCarrier;
 
% low-pass filter y (e.g. via Butterworth filter of order 2) using cutoff frequency fc/10
[b, a] = butter(2, (fc/10)/(fs/2));
ylp = filter(b,a,y);

% remove the mean from the resulting signal.
sDemod = ylp - mean(ylp);

% check: at this point you should have the demodulated signal (the envelope of the
% AM signal). (Don't worry about the initial transient). 
figure;
subplot(2,1,1);
plot(s); grid on; title('Received signal');

subplot(2,1,2);
plot(sDemod); grid on; title('Demodulated signal');
