% problem 3

close all;
clear all;

load rx_signal.mat
load preamble.mat

% Root-raised-cosine parameters
SPAN = 8;
BETA = 0.22;
SPS = 50;

% create the MF filter
mf = rcosdesign(BETA, SPAN, SPS);

% get the sufficient statistics
suffStat = conv(rx_signal, mf);

% we upsample the preamble
pU = upsample(preamble, SPS);

% correlation with the upsampled preamble
R = xcorr(suffStat, pU);
R = R(length(suffStat): length(suffStat) + (length(suffStat) - length(pU)));

% find the index where the (upsampled) preamble starts
[~, ind] = max(abs(R))

% downsample and remove the preamble
symbols = suffStat(ind+length(pU):SPS:end-(length(mf)-1));

scatterplot(symbols); grid on;
title('Received symbols at the output of the MF');