function [s constellation] = my_mapper(b, M)



%% Verify that M is the square of a power of two
if log2(sqrt(M)) ~= fix(log2(sqrt(M)))
    error('M must be in the form of M = 2^(2K), where K is a positive integer.');
end

%% create the constellation

aux = (-(sqrt(M)-1):2:sqrt(M)-1);
[x, y] = meshgrid(aux, fliplr(aux));
c = x + 1i*y;
% We reshape c to be a row vector
constellation = transpose(c(:));
%Generate the unit-norm constellation
constellation = constellation./ sqrt(mean(abs(constellation).^2)); 


%% create a vector of integer that range in [0 M-1]

% number bit per symbol
l = log2(M);
num_bits = length(b);

% reshape the vector to have l bits per row.
num_symbols=num_bits/l;
b=reshape(b,num_symbols,l);

%% mapping
s_int = bi2de(b(:,:)); % binary to dec convertion

% We can use the vector s_int directly to index vector mapping c.
%we just need to add 1 to x since indices start at 1 and not at 0.
s=constellation(s_int+1);

