 % B=MY_IMG2BIT(img_name) 
 
 
 function b=my_img2bit(img_name)

% Read in the image
x = imread(img_name);
 
% Compute the bit per pixel
BPP = max(ceil(log2(double(1+max(max(x)))))); 
% Notice that although max is defined for variable of type uint8, log2 is 
% not, so we need to coherce a cast to double

% Compute the number of pixels
num_pixels = numel(x); 

% Compute the number of pixels
num_bits = BPP*num_pixels ; 

% create the output vector 
b = zeros(1,num_bits);

% write the outpot
b(:) = transpose(de2bi(x(:), 'right-msb', BPP));