function [Es_N0, Eb_N0] = checkSNR(tx, rx, r)

%tx are symbols from a 4QAM constellation, which are sent over an awgn
%channel
%rx are the noise affected received signals
%rate is the encoding rate of the original bits.It should be between 0 
%and 1. If it is not specified, it is assumed to be 1.



% a. Input parameter check
nargin
if (nargin < 2)
     error('Not enough input parameters');
end

if (nargin==2)
    disp('n=2')
    if (size(tx) == size(rx))
       r=1; 
    else
       error('Transmitted and received signals should have the same size');
    end
end

if (nargin > 3)
     error('Too many input parameters');
end

if (r<=0 || r >1)
    error('The coding rate should be between 0 and 1');
end


% b. Determine SNR

noise=rx-tx;

%noise power
N0=mean(abs(noise.^2));

%signal power
Es=mean(abs(tx.^2));

Es_N0=10*log10(Es/N0);


% c. Determine Eb_N0

nb=2;  %2 bits per symbol for 4QAM

Eb_N0=Es_N0-10*log10(nb)-10*log10(r);

%-10*log10(M) compensates for the fact that there are M coded bits per
%modulation symbol

% As r<1, 10*log10(r)<0. This term compensates for the fact that more
% encoded bits are transmitted for each uncoded bit. Since the overall
% energy is the same, the energy of an encoded bit is higher than the
% energy of each coded bit
	
end 