% Problem 2

close all;
clear all;


N = 1024;
T = 1e-6;
fc = 2e8;
bits = [1, 1, -1, 1, 1, -1, 1, -1, 1, -1];


% To Do: generate the matrix X
X = zeros(N,length(bits));
% compute the index
index = 1 + round(fc*T)
X(index, :) = bits;


% To Do: take the IFFT
S = ifft(X,N);


% To Do: serialize to get S
samples = S(:);


% To Do: plot the absolute value of the Fourier transform of S (label the
% frequency axis appropriately)

SAMPLES = fft(samples);

Ts = T/N; % sampling time
Tp = length(SAMPLES)*Ts; 

f = -1/(2*Ts):1/Tp:1/(2*Ts)-1/Tp;
plot(f, fftshift(abs(SAMPLES))); grid on;
xlabel('f [Hz]'); ylabel('abs(fft)');
title('Spectrum of the generated signal');



