% problem 1

close all;
clear all;

% Recall: a page is a 300x5 matrix of 0s and 1s, where the columns are
% subframes. A subframe consists of 10 words, and a word consists of 30
% bits

load('matrixInitial'); 
page = matrixInitial;  % this initial "page" is filled with random bits

% Recall: each subframe starts with the preamble. 
preamble = [1 0 0 0 1 0 1 1]';
% To Do: in the variable "page", substitute the first 8 bits of each column with the preamble
page(1:8,:) = repmat(preamble,1,5);


% Recall: the subframe number is encoded at position 50 - 52 of each
% subframe, with MSB at 50 and LSB at 52.
% To Do: in "page", modify those positions as needed (subframe number 1 ..
% 5 in that order).
subframeNumbers = [0 0 0 1 1 ; 0 1 1 0 0 ; 1 0 1 0 1];
page(50:52,:) = subframeNumbers;

% The following matrix is used to compute the parity bits (d25 through d30
% of each word)
    H = [...
        1 0 1 0 1 0 % multiplies d1
        1 1 0 1 0 0 % multiplies d2 
        1 1 1 0 1 1 % ...
        0 1 1 1 0 0
        1 0 1 1 1 1
        1 1 0 1 1 1
        0 1 1 0 1 0
        0 0 1 1 0 1
        0 0 0 1 1 1
        1 0 0 0 1 1
        1 1 0 0 0 1
        1 1 1 0 0 0
        1 1 1 1 0 1
        1 1 1 1 1 0
        0 1 1 1 1 1
        0 0 1 1 1 0
        1 0 0 1 1 0
        1 1 0 0 1 0
        0 1 1 0 0 1
        1 0 1 1 0 0
        0 1 0 1 1 0
        0 0 1 0 1 1
        1 0 0 1 0 1
        0 1 0 0 1 1 % multiplies d24
        1 0 1 0 0 1 % multiplies D29*
        0 1 0 1 1 0 % multiplies D30*
        ];
    
% To Do: inside the following for loop, update "page" so as to contain the correct
% parity bits (position 25 through 30 of each word) and flip bits 1 through
% 24 if needed. You need to flip if the last bit of the previous word is 1
 previousTwoRows = zeros(2,5); % initialization. 
 % Recall: for the first word of each subframe, D29*=D30*=0.
 NrBitsInWord = 30; % bits per word
 
 for w = 0:9 % word index
     % To Do: insert the parity bits 
     page(25+NrBitsInWord*w:30+NrBitsInWord*w,:) = mod(H' * [page(1+NrBitsInWord*w:24+NrBitsInWord*w,:); previousTwoRows] ,2);   

     % To Do: flip the bits if needed
     page(1+NrBitsInWord*w:24+NrBitsInWord*w,:) = mod(page(1+NrBitsInWord*w:24+NrBitsInWord*w,:) + previousTwoRows(2,:),2);

     % To Do: update the matrix previousTwoRows
     previousTwoRows = page(29+NrBitsInWord*w:30+NrBitsInWord*w,:);

 end
 
 
 % Let us compare your solution (called "page") with ours (called
 % "pageOurSolution")
  load('pageOurSolution');
 % Your solution is identical to ours if the following matrix has only 0s
 % and 2s
 pageOurSolution + page

 
 
