function lambda = my_channel_estMMSE(Rf, N, psd_mask, training_symbols, Ka, delays, sigma2)
%MY_CHANNEL_ESTMMSE Estimate the channel coefficients in the frequency
%domain
%   The channel delays are known. The covariance matrix of channel
%   amplitudes is also assumed to be known.
%   LAMBDA = MY_CHANNEL_ESTMMSE(RF, N, PSD_MASK, ...
%       TRAINING_SYMBOLS, KA, DELAYS, SIGMA2)
%
%       RF: Matrix of TRAINING_SYMBOLS and DATA_SYMBOLS, as returned by
%         OFDM_RX_FRAME.
%       N: number of carriers per OFDM block (power of 2).
%       PSD_MASK: A {0,1}-valued vector of length NUM_CARRIERS, used to
%         to turn off individual carriers.
%       TRAINING_SYMBOLS: vector of symbols known to the receiver, used
%         to estimate the channel. Its length is the number of ones in the
%         PSD_MASK (one training symbol per non-off carrier).
%       KA: the covariance matrix of channel amplitudes.
%       DELAYS: vector containing the delays for each path in the 
%         multipath channel. The delays are expressed in number of 
%         samples, i.e., tau_l/T_s.
%       SIGMA2: noise variance. 
%   LAMBDA: Column vector containing the channel coefficients in the
%   frequency domain. The number of elements in LAMBDA equals the number 
%   of ones in PSD_MASK.
