import numpy as np
import matplotlib.pyplot as plt
import utilMDC
import utilPDC
from scipy import special

# basic script to plot the eye diagram

# Define parameters
nsymbols = int(500)
M = int(2)  # BPSK
bitsPerSymb = int(np.log2(M))
nbits = int(nsymbols * bitsPerSymb)
beta = 0.9
SPAN = int(20)
R = int(100)  # symbols/s
Fs = 5000  # Hz

# derived parameters
SPS = int(Fs/R)  # SPS = T/Ts
T = 1/R

# create the bits (0/1 values)
bits = np.random.randint(2, size=nbits)

# create the symbols (sol_bi2de, sol_qamMap, sol_encoder)
MaryData = utilPDC.sol_bi2de(np.reshape(bits, (nsymbols, bitsPerSymb)))
# encode
map = utilPDC.sol_pskMap(M)
symbols = utilPDC.sol_encoder(MaryData, map)

# map symbols to samples (rcosdesign + sol_symbols2samples)
h = utilPDC.sol_rcosdesign(beta, SPAN, SPS)
# the pulse is already normalized
samples = utilPDC.sol_symbols2samples(symbols, h, SPS)

# plot the RRC filter
utilMDC.tfplot(h, Fs, 'h', 'RRC impulse response, beta = %s, SPAN = %s' % (beta, SPAN))

# ideal impulse response and noiseless channel
received = samples

# generate the sufficient statistics (sol_sufficientStatistics)
suffStat, mfOutput = utilPDC.sol_sufficientStatistics(received, h, SPS)

# plot the eye diagram
utilPDC.sol_eyediagram(mfOutput, Fs, T)
plt.title('Eye Diagram')
plt.show()

# plot the received constellation (output of the MF)
plt.scatter(suffStat.real, suffStat.imag, marker='*')
plt.ylim(-1, 1)  # to get a centered plot
plt.ylabel('Imaginary')
plt.xlabel('Real')
plt.title('Received constellation at the output of the MF')
plt.grid()
plt.show()

