function tx_symbols = my_ofdm_tx_frame(num_carriers, prefix_length, training_symbols, psd_mask, data_symbols)
%   MY_OFDM_TX_FRAME Generates an OFDM frame
%   TX_SYMBOLS = MY_OFDM_TX_FRAME(NUM_CARRIERS, PREFIX_LENGTH, ...
%   TRAINING_SYMBOLS, PSD_MASK, DATA_SYMBOLS)
%
%       NUM_CARRIERS: number of carriers per OFDM block (power of 2)
%       PREFIX_LENGTH: cyclic-prefix length (in number of samples)
%       TRAINING_SYMBOLS: vector of symbols known to the receiver, used
%         to estimate the channel. Its length is the number of ones in the
%         PSD_MASK (one training symbol per non-off carrier).
%       PSD_MASK: A {0,1}-valued vector of length NUM_CARRIERS, used to
%         to turn off individual carriers.
%       DATA_SYMBOLS: vector of symbols to transmit (it
%         will be padded with zeros if the number of data
%         symbols is not a multiple of the number of useful carriers)
%
%   TX_SYMBOLS: A column vector containing the generated OFDM symbols,
%   corresponding to one OFDM frame with the training symbols transmitted
%   during the first OFDM block and the data transmitted in the subsequent
%   OFDM blocks.
