function b = my_de2bi(d, msbflag, n)
%MY_DE2BI Convert decimal numbers to binary numbers
%   B = MY_DE2BI(D) converts a vector D of non-negative integers from base
%   10 to a binary matrix B. Each row of the binary matrix B corresponds
%   to one element of D. The default orientation of the binary output
%   is Right-MSB, i.e., the first element in a row of B represents the
%   least significant bit. If D is a matrix rather than a row or column
%   vector, the matrix is first converted to a vector (column-wise).
%
%   In addition to the input vector D, two optional parameters can
%   be given:
%
%   B = MY_DE2BI(D,MSBFLAG) uses MSBFLAG to determine the output
%   orientation. MSBFLAG has two possible values, 'right-msb' and
%   'left-msb'. Giving a 'right-msb' MSBFLAG does not change the
%   function's default behavior. Giving a 'left-msb' MSBFLAG flips the
%   output orientation to display the MSB to the left.
%
%   B = MY_DE2BI(D,MSBFLAG,N) uses N to define how many binary digits
%   (columns) are output. The number of bits must be large enough to
%   represent the largest number in D.
