function d = my_bi2de(b, msbflag)
%MY_BI2DE Convert binary vectors to decimal numbers
%   D = MY_BI2DE(B) converts a binary vector B to a decimal value D. When
%   B is a matrix, the conversion is performed row-wise and the output
%   D is a column vector of decimal values. The default orientation of
%   the binary input is Right-MSB: the first element in B represents
%   the least significant bit.
%
%   In addition to the input matrix, an optional parameter MSBFLAG can
%   be given:
%
%   D = MY_BI2DE(B, MSBFLAG) uses MSBFLAG to determine the input
%   orientation. MSBFLAG has two possible values, 'right-msb' and
%   'left-msb'. Giving a 'right-msb' MSBFLAG does not change the
%   function's default behavior. Giving a 'left-msb' MSBFLAG flips the
%   input orientation such that the MSB is on the left.
