import numpy as np
import matplotlib.pyplot as plt
import my_utilMDC

# SINCPLOT Time and frequency plot of a sinc signal
# SINCPLOT() creates a new figure window with two subplots, which show
# time and frequency plots for a sinc function.

# Define constants
F_SAMPLE = 5000
DURATION = 0.05
B = 1000

# Set time and frequency scales
t = np.linspace(0, DURATION, int(DURATION*F_SAMPLE + 1))

# Define the signal
m = np.sinc(B*(t - np.amax(t)/2))

my_utilMDC.tfplot(m, F_SAMPLE, 'm', 'A sinc signal')
