import numpy as np
import scipy.io as sio
import matplotlib.pyplot as plt
from scipy.signal import correlate as corr

# Problem 2

# Load the received signal and the training symbols
rx = sio.loadmat('rx_signal.mat')
rx_signal = rx['rx_signal'].flatten()

ts = sio.loadmat('training_symbols.mat')
training_symbols = ts['training_symbols'].flatten()

# Define parameters
N = 256  # number of carriers
L = 25  # length of the cyclic prefix


# Pre-process in an appropriate manner the training symbols, such that we
# can use them for finding the start of the cyclic prefix of the training
# OFDM block in the received samples.
...



# Find the start of the cyclic prefix of the training OFDM block in
# the received samples. Check point: you should find the beginning of the
# cyclic prefix at index 159 in the received samples.
...



# Implement the OFDM receiver for the portion of the received data starting
# with the training OFDM block. Note that you might need to trim the
# received data such that you obtain an integer number of OFDM symbols.
...



# Using the LS approximation, estimate the vector lambda_LS of channel
# coefficients
lambda_LS = ...



# Plot the absolute value of the channel coefficients lambda_LS obtained above.
# The symbol-level impulse response of the channel is h = [1.621, 0.8448, 0.0283].
# Plot the corresponding lambdas (absolute value) on the same figure.
# Check point: lambda_LS should be a noisy version of the lambdas obtained from h.
...



# Using lambda_LS, equalize the OFDM symbols which follow the training
# symbols. Plot (scatterplot) the result. Check point: you should obtain a
# noisy 4-QAM constellation (4 distinct clouds, no rotation).
...


